/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.distribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.router.cache.RouterRuleCache;
import org.apache.servicecomb.router.distribute.RouterDistributor;
import org.apache.servicecomb.router.model.PolicyRuleItem;
import org.apache.servicecomb.router.model.RouteItem;
import org.apache.servicecomb.router.model.TagItem;
import org.apache.servicecomb.router.util.VersionCompareUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractRouterDistributor<INSTANCE>
implements RouterDistributor<INSTANCE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRouterDistributor.class);
    private Function<INSTANCE, String> getVersion;
    private Function<INSTANCE, String> getServerName;
    private Function<INSTANCE, Map<String, String>> getProperties;
    private RouterRuleCache routerRuleCache;

    @Autowired
    public void setRouterRuleCache(RouterRuleCache routerRuleCache) {
        this.routerRuleCache = routerRuleCache;
    }

    protected AbstractRouterDistributor() {
    }

    @Override
    public List<INSTANCE> distribute(String targetServiceName, List<INSTANCE> list, PolicyRuleItem invokeRule) {
        this.initLatestVersion(targetServiceName, list);
        invokeRule.check(this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getLatestVersionTag());
        Map<TagItem, List<INSTANCE>> versionServerMap = this.getDistributList(targetServiceName, list, invokeRule);
        if (CollectionUtils.isEmpty(versionServerMap)) {
            LOGGER.debug("route management can not match any rule and route the latest version");
            return this.getLatestVersionList(list, targetServiceName);
        }
        TagItem targetTag = this.getFiltedServerTagItem(invokeRule, targetServiceName);
        if (versionServerMap.containsKey(targetTag)) {
            return versionServerMap.get(targetTag);
        }
        return this.getLatestVersionList(list, targetServiceName);
    }

    @Override
    public void init(Function<INSTANCE, String> getVersion, Function<INSTANCE, String> getServerName, Function<INSTANCE, Map<String, String>> getProperties) {
        this.getVersion = getVersion;
        this.getServerName = getServerName;
        this.getProperties = getProperties;
    }

    public TagItem getFiltedServerTagItem(PolicyRuleItem rule, String targetServiceName) {
        return this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getNextInvokeVersion(rule);
    }

    private Map<TagItem, List<INSTANCE>> getDistributList(String serviceName, List<INSTANCE> list, PolicyRuleItem invokeRule) {
        String latestV = this.routerRuleCache.getServiceInfoCacheMap().get(serviceName).getLatestVersionTag().getVersion();
        HashMap<TagItem, List<INSTANCE>> versionServerMap = new HashMap<TagItem, List<INSTANCE>>();
        for (INSTANCE instance : list) {
            if (!this.getServerName.apply(instance).equals(serviceName)) continue;
            TagItem tagItem = new TagItem(this.getVersion.apply(instance), this.getProperties.apply(instance));
            TagItem targetTag = null;
            int maxMatch = 0;
            for (RouteItem entry : invokeRule.getRoute()) {
                int nowMatch;
                if (entry.getTagitem() == null || (nowMatch = entry.getTagitem().matchNum(tagItem)) <= maxMatch) continue;
                maxMatch = nowMatch;
                targetTag = entry.getTagitem();
            }
            if (invokeRule.isWeightLess() && this.getVersion.apply(instance).equals(latestV)) {
                TagItem latestVTag = invokeRule.getRoute().get(invokeRule.getRoute().size() - 1).getTagitem();
                if (!versionServerMap.containsKey(latestVTag)) {
                    versionServerMap.put(latestVTag, new ArrayList());
                }
                ((List)versionServerMap.get(latestVTag)).add(instance);
            }
            if (targetTag == null) continue;
            if (!versionServerMap.containsKey(targetTag)) {
                versionServerMap.put(targetTag, new ArrayList());
            }
            ((List)versionServerMap.get(targetTag)).add(instance);
        }
        return versionServerMap;
    }

    public void initLatestVersion(String serviceName, List<INSTANCE> list) {
        String latestVersion = null;
        for (INSTANCE instance : list) {
            if (!this.getServerName.apply(instance).equals(serviceName) || latestVersion != null && VersionCompareUtil.compareVersion(latestVersion, this.getVersion.apply(instance)) != -1) continue;
            latestVersion = this.getVersion.apply(instance);
        }
        TagItem tagitem = new TagItem(latestVersion);
        this.routerRuleCache.getServiceInfoCacheMap().get(serviceName).setLatestVersionTag(tagitem);
    }

    public List<INSTANCE> getLatestVersionList(List<INSTANCE> list, String targetServiceName) {
        String latestV = this.routerRuleCache.getServiceInfoCacheMap().get(targetServiceName).getLatestVersionTag().getVersion();
        return list.stream().filter(instance -> this.getVersion.apply(instance).equals(latestV)).collect(Collectors.toList());
    }
}

