/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZipkinTracingHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipkinTracingHandler.class);
    private final Tracing tracer;
    private final ZipkinTracingDelegate tracingDelegate;

    ZipkinTracingHandler(ZipkinTracingDelegate tracingDelegate) {
        this.tracer = tracingDelegate.tracer();
        this.tracingDelegate = tracingDelegate;
    }

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        Span span = this.tracingDelegate.createSpan(invocation);
        try (Tracer.SpanInScope scope = this.tracer.tracer().withSpanInScope(span);){
            LOGGER.debug("{}: Generated tracing span for {}", (Object)this.tracingDelegate.name(), (Object)invocation.getOperationName());
            invocation.next(this.onResponse(invocation, asyncResp, span));
        }
        catch (Exception e) {
            LOGGER.debug("{}: Failed invocation on {}", new Object[]{this.tracingDelegate.name(), invocation.getOperationName(), e});
            this.tracingDelegate.onResponse(span, null, e);
            throw e;
        }
    }

    private AsyncResponse onResponse(Invocation invocation, AsyncResponse asyncResp, Span span) {
        return response -> {
            Throwable error = response.isFailed() ? (Throwable)response.getResult() : null;
            this.tracingDelegate.onResponse(span, response, error);
            LOGGER.debug("{}: Completed invocation on {}", new Object[]{this.tracingDelegate.name(), invocation.getOperationName(), error});
            asyncResp.handle(response);
        };
    }
}

