/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.governance.handler.InstanceIsolationHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.registry.api.MicroserviceKey;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.registry.api.event.ServiceCenterEventBus;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInstanceIsolationHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerInstanceIsolationHandler.class);
    private final InstanceIsolationHandler instanceIsolationHandler = (InstanceIsolationHandler)BeanUtils.getBean(InstanceIsolationHandler.class);

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getEndpoint() == null) {
            invocation.next(asyncResp);
            return;
        }
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequestExtractor request = MatchType.createGovHttpRequest((Invocation)invocation);
        this.addCircuitBreaker((Decorators.DecorateCompletionStage<Response>)dcs, request);
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                asyncResp.complete(r);
                return;
            }
            if (e instanceof CallNotPermittedException) {
                LOGGER.warn("instance isolation circuitBreaker is open by policy : {}", (Object)e.getMessage());
                ServiceCenterEventBus.getEventBus().post(this.createMicroserviceInstanceChangedEvent(invocation));
                asyncResp.complete(Response.failResp((InvocationException)new InvocationException(503, "instance isolation circuitBreaker is open.", (Object)new CommonExceptionData("instance isolation circuitBreaker is open."))));
            } else {
                asyncResp.complete(Response.createProducerFail((Throwable)e));
            }
        });
    }

    private Object createMicroserviceInstanceChangedEvent(Invocation invocation) {
        MicroserviceInstanceChangedEvent event = new MicroserviceInstanceChangedEvent();
        MicroserviceKey key = new MicroserviceKey();
        key.setAppId(invocation.getAppId());
        key.setServiceName(invocation.getMicroserviceName());
        event.setKey(key);
        return event;
    }

    private void addCircuitBreaker(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequestExtractor request) {
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.instanceIsolationHandler.getActuator(request);
        if (circuitBreaker != null) {
            dcs.withCircuitBreaker(circuitBreaker);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation) {
        return () -> {
            CompletableFuture result = new CompletableFuture();
            try {
                invocation.next(result::complete);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        };
    }
}

