/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filterext;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ServerListFilterExt;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.event.IsolationServerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolationDiscoveryFilter
implements ServerListFilterExt {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolationDiscoveryFilter.class);
    private final DynamicBooleanProperty emptyProtection = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.emptyInstanceProtectionEnabled", false);
    private final EventBus eventBus = EventManager.getEventBus();

    @Override
    public int getOrder() {
        return -100;
    }

    public IsolationDiscoveryFilter() {
        this.emptyProtection.addCallback(() -> {
            boolean newValue = this.emptyProtection.get();
            LOGGER.info("{} changed from {} to {}", new Object[]{"servicecomb.loadbalance.filter.isolation.emptyInstanceProtectionEnabled", this.emptyProtection, newValue});
        });
    }

    @Override
    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.enabled", false).get();
    }

    @Override
    public List<ServiceCombServer> getFilteredListOfServers(List<ServiceCombServer> servers, Invocation invocation) {
        if (!Configuration.INSTANCE.isIsolationFilterOpen(invocation.getMicroserviceName())) {
            return servers;
        }
        ArrayList<ServiceCombServer> filteredServers = new ArrayList<ServiceCombServer>();
        Settings settings = this.createSettings(invocation);
        servers.forEach(server -> {
            if (this.allowVisit(invocation, (ServiceCombServer)((Object)server), settings)) {
                filteredServers.add((ServiceCombServer)((Object)server));
            }
        });
        if (filteredServers.isEmpty() && this.emptyProtection.get()) {
            LOGGER.warn("All servers have been isolated, allow one of them based on load balance rule.");
            return servers;
        }
        return filteredServers;
    }

    private Settings createSettings(Invocation invocation) {
        Settings settings = new Settings();
        settings.errorThresholdPercentage = Configuration.INSTANCE.getErrorThresholdPercentage(invocation.getMicroserviceName());
        settings.singleTestTime = Configuration.INSTANCE.getSingleTestTime(invocation.getMicroserviceName());
        settings.enableRequestThreshold = Configuration.INSTANCE.getEnableRequestThreshold(invocation.getMicroserviceName());
        settings.continuousFailureThreshold = Configuration.INSTANCE.getContinuousFailureThreshold(invocation.getMicroserviceName());
        settings.minIsolationTime = Configuration.INSTANCE.getMinIsolationTime(invocation.getMicroserviceName());
        return settings;
    }

    private boolean allowVisit(Invocation invocation, ServiceCombServer server, Settings settings) {
        ServiceCombServerStats serverStats = ServiceCombLoadBalancerStats.INSTANCE.getServiceCombServerStats(server);
        if (!this.checkThresholdAllowed(settings, serverStats)) {
            if (serverStats.isIsolated() && System.currentTimeMillis() - serverStats.getLastVisitTime() > settings.singleTestTime) {
                return ServiceCombServerStats.applyForTryingChance(invocation);
            }
            if (!serverStats.isIsolated()) {
                serverStats.markIsolated(true);
                this.eventBus.post((Object)new IsolationServerEvent(invocation, server.getInstance(), serverStats, settings, AlarmEvent.Type.OPEN, server.getEndpoint()));
                LOGGER.warn("Isolate service {}'s instance {}.", (Object)invocation.getMicroserviceName(), (Object)server.getInstance().getInstanceId());
            }
            return false;
        }
        if (serverStats.isIsolated()) {
            if (System.currentTimeMillis() - serverStats.getIsolatedTime() <= (long)settings.minIsolationTime) {
                return false;
            }
            serverStats.markIsolated(false);
            this.eventBus.post((Object)new IsolationServerEvent(invocation, server.getInstance(), serverStats, settings, AlarmEvent.Type.CLOSE, server.getEndpoint()));
            LOGGER.warn("Recover service {}'s instance {} from isolation.", (Object)invocation.getMicroserviceName(), (Object)server.getInstance().getInstanceId());
        }
        return true;
    }

    private boolean checkThresholdAllowed(Settings settings, ServiceCombServerStats serverStats) {
        if (serverStats.getTotalRequests() < settings.enableRequestThreshold) {
            return true;
        }
        if (settings.continuousFailureThreshold > 0 && serverStats.getContinuousFailureCount() >= (long)settings.continuousFailureThreshold) {
            return false;
        }
        if (settings.errorThresholdPercentage == 0) {
            return true;
        }
        return serverStats.getFailedRate() < settings.errorThresholdPercentage;
    }

    public static class Settings {
        public int errorThresholdPercentage;
        public long singleTestTime;
        public long enableRequestThreshold;
        public int continuousFailureThreshold;
        public int minIsolationTime;
    }
}

