/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.api.Discovery;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.lightweight.SchemaChangedEvent;
import org.apache.servicecomb.registry.lightweight.store.MicroserviceStore;
import org.apache.servicecomb.registry.lightweight.store.Store;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLightweightDiscovery
implements Discovery,
InitializingBean {
    protected EventBus eventBus;
    protected Store store;
    protected AppManager appManager;

    @Autowired
    public AbstractLightweightDiscovery setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        return this;
    }

    @Autowired
    public AbstractLightweightDiscovery setStore(Store store) {
        this.store = store;
        return this;
    }

    @Autowired
    public AbstractLightweightDiscovery setAppManager(AppManager appManager) {
        this.appManager = appManager;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void onSchemaChanged(SchemaChangedEvent event) {
        Microservice microservice = event.getMicroservice();
        this.appManager.markWaitingDelete(microservice.getAppId(), microservice.getServiceName());
    }

    protected void startPullInstances(Duration pullInterval) {
        Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, this.name())).scheduleAtFixedRate(() -> ((AppManager)this.appManager).safePullInstances(), 0L, pullInterval.getSeconds(), TimeUnit.SECONDS);
    }

    public void init() {
    }

    public void run() {
    }

    public void destroy() {
    }

    public Microservice getMicroservice(String microserviceId) {
        return this.store.getMicroservice(microserviceId).orElse(null);
    }

    public List<Microservice> getAllMicroservices() {
        return this.store.getAllMicroservices();
    }

    public String getSchema(String microserviceId, Collection<MicroserviceInstance> instances, String schemaId) {
        return Optional.ofNullable(this.store.findMicroserviceStore(microserviceId)).map(MicroserviceStore::getMicroservice).map(microservice -> (String)microservice.getSchemaMap().get(schemaId)).orElse(null);
    }

    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        return this.store.getMicroserviceInstance(instanceId).orElse(null);
    }

    public MicroserviceInstances findServiceInstances(String appId, String serviceName, String uselessVersionRule, String revision) {
        return this.store.findServiceInstances(appId, serviceName, revision);
    }
}

