/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableHolder;
import org.apache.servicecomb.governance.handler.RateLimitingHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.MapperPolicy;
import org.apache.servicecomb.governance.processor.mapping.Mapper;
import org.apache.servicecomb.governance.properties.MapperProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperHandler
extends AbstractGovernanceHandler<Mapper, MapperPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimitingHandler.class);
    private final MapperProperties mapperProperties;

    public MapperHandler(MapperProperties mapperProperties) {
        this.mapperProperties = mapperProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, MapperPolicy policy) {
        return this.mapperProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    public MapperPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (MapperPolicy)this.matchersManager.match(governanceRequest, this.mapperProperties.getParsedEntity());
    }

    @Override
    public Disposable<Mapper> createProcessor(String key, GovernanceRequest governanceRequest, MapperPolicy policy) {
        return this.getMapper(key, policy);
    }

    private Disposable<Mapper> getMapper(String key, MapperPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        return new DisposableHolder<Mapper>(key, Mapper.create(policy.getTarget()));
    }
}

