/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.decorators.Decorators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.governance.handler.InstanceBulkheadHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInstanceBulkheadHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerInstanceBulkheadHandler.class);
    private final InstanceBulkheadHandler instanceBulkheadHandler = (InstanceBulkheadHandler)BeanUtils.getBean(InstanceBulkheadHandler.class);

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getEndpoint() == null) {
            invocation.next(asyncResp);
            return;
        }
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequest request = MatchType.createGovHttpRequest((Invocation)invocation);
        request.setServiceName(invocation.getMicroserviceName());
        request.setInstanceId(invocation.getEndpoint().getMicroserviceInstance().getInstanceId());
        this.addBulkhead((Decorators.DecorateCompletionStage<Response>)dcs, request);
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                asyncResp.complete(r);
                return;
            }
            if (e instanceof BulkheadFullException) {
                asyncResp.complete(Response.failResp((InvocationException)new InvocationException(503, "bulkhead is full and does not permit further calls.", (Object)new CommonExceptionData("bulkhead is full and does not permit further calls."))));
                LOGGER.warn("bulkhead is full and does not permit further calls by policy : {}", (Object)e.getMessage());
            } else {
                asyncResp.complete(Response.createProducerFail((Throwable)e));
            }
        });
    }

    private void addBulkhead(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequest request) {
        Bulkhead bulkhead = (Bulkhead)this.instanceBulkheadHandler.getActuator(request);
        if (bulkhead != null) {
            dcs.withBulkhead(bulkhead);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation) {
        return () -> {
            CompletableFuture result = new CompletableFuture();
            try {
                invocation.next(result::complete);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        };
    }
}

