/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableHolder;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.GovernanceCachePolicy;
import org.apache.servicecomb.governance.properties.GovernanceCacheProperties;
import org.apache.servicecomb.governance.service.GovernanceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovernanceCacheHandler<K, V>
extends AbstractGovernanceHandler<GovernanceCache<K, V>, GovernanceCachePolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GovernanceCacheHandler.class);
    private final GovernanceCacheProperties cacheProperties;

    public GovernanceCacheHandler(GovernanceCacheProperties cacheProperties) {
        this.cacheProperties = cacheProperties;
    }

    @Override
    public GovernanceCachePolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (GovernanceCachePolicy)this.matchersManager.match(governanceRequest, this.cacheProperties.getParsedEntity());
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, GovernanceCachePolicy policy) {
        return this.cacheProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    protected Disposable<GovernanceCache<K, V>> createProcessor(String key, GovernanceRequest governanceRequest, GovernanceCachePolicy policy) {
        return this.getGovernanceCache(key, policy);
    }

    protected Disposable<GovernanceCache<K, V>> getGovernanceCache(String key, GovernanceCachePolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.parse(policy.getTtl())).maximumSize(policy.getMaximumSize().longValue()).concurrencyLevel(policy.getConcurrencyLevel()).build();
        GovernanceCache governanceCache = GovernanceCache.of(cache);
        return new DisposableHolder(key, governanceCache);
    }
}

