/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.governance.RetryContext;
import org.apache.servicecomb.core.handler.impl.SimpleLoadBalanceHandler;
import org.apache.servicecomb.core.registry.discovery.EndpointDiscoveryFilter;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SimpleLoadBalanceFilter
implements ConsumerFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLoadBalanceHandler.class);
    public static final String NAME = "simple-load-balance";
    private final Map<String, Service> servicesByName = new ConcurrentHashMapEx();

    @Override
    @Nonnull
    public String getName() {
        return NAME;
    }

    @Override
    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        if (invocation.getEndpoint() != null) {
            invocation.addLocalContext("x-context-retry-loadbalance", false);
            return nextNode.onFilter(invocation);
        }
        invocation.addLocalContext("x-context-retry-loadbalance", true);
        Service service = this.servicesByName.computeIfAbsent(invocation.getMicroserviceName(), Service::new);
        Endpoint endpoint = service.selectEndpoint(invocation);
        invocation.setEndpoint(endpoint);
        return nextNode.onFilter(invocation);
    }

    private static class Service {
        public static final String CONTEXT_KEY_LAST_SERVER = "x-context-last-server";
        private static final int COUNT = 17;
        private final String name;
        private final DiscoveryTree discoveryTree = new DiscoveryTree();
        private final Map<String, AtomicInteger> indexMap = new ConcurrentHashMapEx();

        public Service(String name) {
            this.name = name;
            this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
            this.discoveryTree.addFilter((DiscoveryFilter)new EndpointDiscoveryFilter());
            this.discoveryTree.sort();
        }

        public String getName() {
            return this.name;
        }

        public Endpoint selectEndpoint(Invocation invocation) {
            DiscoveryContext context = new DiscoveryContext();
            context.setInputParameters((Object)invocation);
            DiscoveryTreeNode endpointsVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
            if (endpointsVersionedCache.isEmpty()) {
                String msg = "No available address found.";
                LOGGER.error("{} microserviceName={}, version={}, discoveryGroupName={}", new Object[]{msg, invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule(), endpointsVersionedCache.name()});
                throw Exceptions.consumer("SCB.00000001", msg);
            }
            return this.selectEndpoint(invocation, endpointsVersionedCache.name(), (List)endpointsVersionedCache.data());
        }

        private Endpoint selectEndpoint(Invocation invocation, String key, List<Endpoint> endpoints) {
            Endpoint lastServer;
            RetryContext retryContext = (RetryContext)invocation.getLocalContext("x-context-retry");
            if (retryContext == null) {
                return this.chooseEndpoint(invocation, key, endpoints);
            }
            if (!retryContext.isRetry()) {
                Endpoint server = this.chooseEndpoint(invocation, key, endpoints);
                invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, server);
                return server;
            }
            Endpoint nextServer = lastServer = (Endpoint)invocation.getLocalContext(CONTEXT_KEY_LAST_SERVER);
            if (!retryContext.trySameServer()) {
                Endpoint s;
                for (int i = 0; i < 17 && (s = this.chooseEndpoint(invocation, key, endpoints)) != null; ++i) {
                    if (s.equals(nextServer)) continue;
                    nextServer = s;
                    break;
                }
            }
            LOGGER.info("operation failed {}, retry to instance [{}], last instance [{}], trace id {}", new Object[]{invocation.getMicroserviceQualifiedName(), nextServer == null ? "" : nextServer.getEndpoint(), lastServer == null ? "" : lastServer.getEndpoint(), invocation.getTraceId()});
            invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, nextServer);
            return nextServer;
        }

        private Endpoint chooseEndpoint(Invocation invocation, String key, List<Endpoint> endpoints) {
            AtomicInteger index = this.indexMap.computeIfAbsent(key, name -> {
                LOGGER.info("Create loadBalancer for {}.", name);
                return new AtomicInteger();
            });
            LOGGER.debug("invocation {} use discoveryGroup {}.", (Object)invocation.getMicroserviceQualifiedName(), (Object)key);
            int idx = Math.abs(index.getAndIncrement());
            return endpoints.get(idx %= endpoints.size());
        }
    }
}

