/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.loadbalancer.Server;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.governance.RetryContext;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.filter.ServerDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadbalanceHandler
implements Handler {
    public static final String CONTEXT_KEY_LAST_SERVER = "x-context-last-server";
    private static final int COUNT = 17;
    public static final String CONTEXT_KEY_SERVER_LIST = "x-context-server-list";
    public static final String SERVICECOMB_SERVER_ENDPOINT = "scb-endpoint";
    public static final boolean supportDefinedEndpoint = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.userDefinedEndpoint.enabled", false).get();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadbalanceHandler.class);
    private DiscoveryTree discoveryTree = new DiscoveryTree();
    private final Map<String, LoadBalancer> loadBalancerMap = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private String strategy = null;

    public LoadbalanceHandler(DiscoveryTree discoveryTree) {
        this.discoveryTree = discoveryTree;
    }

    public LoadbalanceHandler() {
        this.preCheck();
        this.discoveryTree.loadFromSPI(DiscoveryFilter.class);
        this.discoveryTree.addFilter((DiscoveryFilter)new ServerDiscoveryFilter());
        this.discoveryTree.sort();
    }

    private void preCheck() {
        String filterNames;
        String policyName = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.loadbalance.NFLoadBalancerRuleClassName", null).get();
        if (!StringUtils.isEmpty((CharSequence)policyName)) {
            LOGGER.error("[servicecomb.loadbalance.NFLoadBalancerRuleClassName] is not supported anymore.use [servicecomb.loadbalance.strategy.name] instead.");
        }
        if (!StringUtils.isEmpty((CharSequence)(filterNames = Configuration.getStringProperty(null, "servicecomb.loadbalance.serverListFilters")))) {
            LOGGER.error("Server list implementation changed to SPI. Configuration [servicecomb.loadbalance.serverListFilters] is not used any more. For ServiceComb defined filters, you do not need config and can remove this configuration safely. If you define your own filter, need to change it to SPI to make it work.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        AsyncResponse response = asyncResp;
        if (this.handleSuppliedEndpoint(invocation, asyncResp = async -> {
            ServiceCombServerStats.checkAndReleaseTryingChance(invocation);
            response.handle(async);
        })) {
            invocation.addLocalContext("x-context-retry-loadbalance", (Object)false);
            return;
        }
        invocation.addLocalContext("x-context-retry-loadbalance", (Object)true);
        String strategy = Configuration.INSTANCE.getRuleStrategyName(invocation.getMicroserviceName());
        if (!Objects.equals(strategy, this.strategy)) {
            Object object = this.lock;
            synchronized (object) {
                this.clearLoadBalancer();
            }
        }
        this.strategy = strategy;
        LoadBalancer loadBalancer = this.getOrCreateLoadBalancer(invocation);
        this.send(invocation, asyncResp, loadBalancer);
    }

    private boolean handleSuppliedEndpoint(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        if (invocation.getEndpoint() != null) {
            invocation.next(asyncResp);
            return true;
        }
        if (supportDefinedEndpoint) {
            return this.defineEndpointAndHandle(invocation, asyncResp);
        }
        return false;
    }

    private Endpoint parseEndpoint(String endpointUri) throws Exception {
        URI formatUri = new URI(endpointUri);
        Transport transport = SCBEngine.getInstance().getTransportManager().findTransport(formatUri.getScheme());
        if (transport == null) {
            LOGGER.error("not deployed transport {}, ignore {}.", (Object)formatUri.getScheme(), (Object)endpointUri);
            throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "the endpoint's transport is not found.");
        }
        return new Endpoint(transport, endpointUri);
    }

    private boolean defineEndpointAndHandle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        Object endpoint = invocation.getLocalContext(SERVICECOMB_SERVER_ENDPOINT);
        if (endpoint == null) {
            return false;
        }
        if (endpoint instanceof String) {
            endpoint = this.parseEndpoint((String)endpoint);
        }
        invocation.setEndpoint((Endpoint)endpoint);
        invocation.next(asyncResp);
        return true;
    }

    private void clearLoadBalancer() {
        this.loadBalancerMap.clear();
    }

    @VisibleForTesting
    void send(Invocation invocation, AsyncResponse asyncResp, LoadBalancer chosenLB) throws Exception {
        long time = System.currentTimeMillis();
        ServiceCombServer server = this.chooseServer(invocation, chosenLB);
        if (null == server) {
            asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "No available address found."));
            return;
        }
        chosenLB.getLoadBalancerStats().incrementNumRequests((Server)server);
        invocation.setEndpoint(server.getEndpoint());
        invocation.next(resp -> {
            chosenLB.getLoadBalancerStats().noteResponseTime((Server)server, (double)(System.currentTimeMillis() - time));
            if (this.isFailedResponse(resp)) {
                chosenLB.getLoadBalancerStats().incrementSuccessiveConnectionFailureCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markFailure(server);
            } else {
                chosenLB.getLoadBalancerStats().incrementActiveRequestsCount((Server)server);
                ServiceCombLoadBalancerStats.INSTANCE.markSuccess(server);
            }
            asyncResp.handle(resp);
        });
    }

    private ServiceCombServer chooseServer(Invocation invocation, LoadBalancer chosenLB) {
        ServiceCombServer lastServer;
        RetryContext retryContext = (RetryContext)invocation.getLocalContext("x-context-retry");
        if (retryContext == null) {
            return chosenLB.chooseServer(invocation);
        }
        if (!retryContext.isRetry()) {
            ServiceCombServer server = chosenLB.chooseServer(invocation);
            invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, (Object)server);
            return server;
        }
        ServiceCombServer nextServer = lastServer = (ServiceCombServer)((Object)invocation.getLocalContext(CONTEXT_KEY_LAST_SERVER));
        if (!retryContext.trySameServer()) {
            ServiceCombServer s;
            for (int i = 0; i < 17 && (s = chosenLB.chooseServer(invocation)) != null; ++i) {
                if (s.equals((Object)nextServer)) continue;
                nextServer = s;
                break;
            }
        }
        LOGGER.warn("operation failed {}, retry to instance [{}], last instance [{}], trace id {}", new Object[]{invocation.getMicroserviceQualifiedName(), nextServer == null ? "" : nextServer.getHostPort(), lastServer == null ? "" : lastServer.getHostPort(), invocation.getTraceId()});
        invocation.addLocalContext(CONTEXT_KEY_LAST_SERVER, (Object)nextServer);
        return nextServer;
    }

    protected boolean isFailedResponse(Response resp) {
        if (resp.isFailed()) {
            if (resp.getResult() instanceof InvocationException) {
                InvocationException e = (InvocationException)resp.getResult();
                return e.getStatusCode() == 490 || e.getStatusCode() == Response.Status.SERVICE_UNAVAILABLE.getStatusCode() || e.getStatusCode() == Response.Status.REQUEST_TIMEOUT.getStatusCode();
            }
            return true;
        }
        return false;
    }

    protected LoadBalancer getOrCreateLoadBalancer(Invocation invocation) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)invocation);
        DiscoveryTreeNode serversVersionedCache = this.discoveryTree.discovery(context, invocation.getAppId(), invocation.getMicroserviceName(), invocation.getMicroserviceVersionRule());
        invocation.addLocalContext(CONTEXT_KEY_SERVER_LIST, serversVersionedCache.data());
        return this.loadBalancerMap.computeIfAbsent(serversVersionedCache.name(), name -> this.createLoadBalancer(invocation.getMicroserviceName()));
    }

    private LoadBalancer createLoadBalancer(String microserviceName) {
        RuleExt rule = ExtensionsManager.createLoadBalancerRule(microserviceName);
        return new LoadBalancer(rule, microserviceName);
    }
}

