/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.ws;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketBase;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.core.executor.ReactiveExecutor;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.ws.AbstractBaseWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.BinaryBytesWebSocketMessage;
import org.apache.servicecomb.swagger.invocation.ws.SerialExecutorWrapper;
import org.apache.servicecomb.swagger.invocation.ws.TextWebSocketMessage;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketAdapter;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketFrame;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebSocketAdaptor
implements WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxWebSocketAdaptor.class);
    private static final int DEFAULT_ADAPTER_QUEUE_MAX_SIZE = 100;
    private static final int DEFAULT_ADAPTER_QUEUE_MAX_CONTINUE_TIMES = 10;
    private final Executor executor;
    private final AbstractBaseWebSocket bizWebSocket;
    private final WebSocketBase vertxWebSocket;
    private final AtomicBoolean inPauseStatus;
    private final String websocketSessionId;
    private final InvocationType invocationType;

    public VertxWebSocketAdaptor(InvocationType invocationType, String websocketSessionId, Executor workerPool, AbstractBaseWebSocket bizWebSocket, WebSocketBase vertxWebSocket) {
        Objects.requireNonNull(invocationType, "VertxWebSocketAdaptor invocationType is null");
        Objects.requireNonNull(websocketSessionId, "VertxWebSocketAdaptor websocketSessionId is null");
        Objects.requireNonNull(workerPool, "VertxWebSocketAdaptor workerPool is null");
        Objects.requireNonNull(bizWebSocket, "VertxWebSocketAdaptor bizWebSocket is null");
        Objects.requireNonNull(vertxWebSocket, "VertxWebSocketAdaptor vertxWebSocket is null");
        this.invocationType = invocationType;
        this.websocketSessionId = websocketSessionId;
        this.executor = workerPool instanceof ReactiveExecutor ? workerPool : this.prepareSerialExecutorWrapper(workerPool);
        this.bizWebSocket = bizWebSocket;
        this.vertxWebSocket = vertxWebSocket;
        this.inPauseStatus = new AtomicBoolean(true);
        vertxWebSocket.pause();
        this.linkVertxToBiz();
        this.linkBizToVertx(bizWebSocket);
        this.startWorking();
    }

    private void linkBizToVertx(AbstractBaseWebSocket bizWebSocket) {
        bizWebSocket.setWebSocketAdapter((WebSocketAdapter)this);
    }

    private SerialExecutorWrapper prepareSerialExecutorWrapper(Executor workerPool) {
        SerialExecutorWrapper wrapper = new SerialExecutorWrapper(this.invocationType, this.websocketSessionId, workerPool, DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.adapter.queue.maxSize", 100).get(), DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.adapter.queue.maxContinueTimes", 10).get());
        wrapper.subscribeQueueDrainEvent(this::resume);
        wrapper.subscribeQueueFullEvent(this::pause);
        return wrapper;
    }

    private void linkVertxToBiz() {
        this.linkVertxDrainHandler();
        this.linkVertxTextMessageHandler();
        this.linkVertxBinaryMessageHandler();
        this.linkVertxFrameHandler();
        this.linkVertxExceptionHandler();
        this.linkVertxCloseHandler();
    }

    private void linkVertxCloseHandler() {
        this.vertxWebSocket.closeHandler(v -> this.scheduleTask(() -> this.bizWebSocket.onClose(this.vertxWebSocket.closeStatusCode(), this.vertxWebSocket.closeReason())));
    }

    private void linkVertxExceptionHandler() {
        this.vertxWebSocket.exceptionHandler(t -> this.scheduleTask(() -> this.bizWebSocket.onError(t)));
    }

    private void linkVertxFrameHandler() {
    }

    private void linkVertxBinaryMessageHandler() {
        this.vertxWebSocket.binaryMessageHandler(buffer -> {
            byte[] bytes = buffer.getBytes();
            this.scheduleTask(() -> this.bizWebSocket.onMessage((WebSocketMessage)new BinaryBytesWebSocketMessage(bytes)));
        });
    }

    private void linkVertxTextMessageHandler() {
        this.vertxWebSocket.textMessageHandler(s -> this.scheduleTask(() -> this.bizWebSocket.onMessage((WebSocketMessage)new TextWebSocketMessage(s))));
    }

    private void linkVertxDrainHandler() {
        this.vertxWebSocket.drainHandler(v -> this.scheduleTask(() -> ((AbstractBaseWebSocket)this.bizWebSocket).onWriteQueueDrain()));
    }

    private void startWorking() {
        this.scheduleTask(() -> ((AbstractBaseWebSocket)this.bizWebSocket).startWorking());
    }

    private void scheduleTask(Runnable task) {
        try {
            this.executor.execute(task);
        }
        catch (Throwable e) {
            LOGGER.error("[{}]-[{}] error occurs in scheduleTask", new Object[]{this.invocationType, this.websocketSessionId, e});
        }
    }

    public CompletableFuture<Void> sendMessage(WebSocketMessage<?> message) {
        if (message instanceof TextWebSocketMessage) {
            return this.vertxWebSocket.writeTextMessage((String)((TextWebSocketMessage)message).getPayload()).toCompletionStage().toCompletableFuture();
        }
        if (message instanceof BinaryBytesWebSocketMessage) {
            return this.vertxWebSocket.writeBinaryMessage(Buffer.buffer((byte[])((byte[])((BinaryBytesWebSocketMessage)message).getPayload()))).toCompletionStage().toCompletableFuture();
        }
        throw new IllegalStateException("impossible case, unrecognized WebSocketMessage type!");
    }

    public CompletableFuture<Void> sendFrame(WebSocketFrame frame) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> close(short statusCode, String reason) {
        return this.vertxWebSocket.close(statusCode, reason).toCompletionStage().toCompletableFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (!this.inPauseStatus.compareAndSet(false, true)) {
            return;
        }
        LOGGER.info("[{}]-[{}] pause websocket", (Object)this.invocationType, (Object)this.websocketSessionId);
        VertxWebSocketAdaptor vertxWebSocketAdaptor = this;
        synchronized (vertxWebSocketAdaptor) {
            this.vertxWebSocket.pause();
            this.inPauseStatus.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (!this.inPauseStatus.compareAndSet(true, false)) {
            return;
        }
        LOGGER.info("[{}]-[{}] resume websocket", (Object)this.invocationType, (Object)this.websocketSessionId);
        VertxWebSocketAdaptor vertxWebSocketAdaptor = this;
        synchronized (vertxWebSocketAdaptor) {
            this.vertxWebSocket.resume();
            this.inPauseStatus.set(false);
        }
    }

    public boolean writeQueueFull() {
        return this.vertxWebSocket.writeQueueFull();
    }
}

