/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.ws;

import io.vertx.core.http.WebSocketBase;
import java.util.concurrent.Executor;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.ws.VertxClientWebSocketResponseToHttpServletResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.apache.servicecomb.swagger.invocation.ws.AbstractBaseWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.ClientWebSocket;
import org.apache.servicecomb.swagger.invocation.ws.WebSocketPipe;
import org.apache.servicecomb.transport.rest.vertx.ws.VertxWebSocketAdaptor;

public class WebSocketResponseWrapClientFilter
implements HttpClientFilter {
    public boolean enabled() {
        return super.enabled();
    }

    public boolean enabledForTransport(String transport) {
        return "websocket".equals(transport);
    }

    public int getOrder() {
        return 10010;
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        if (!(responseEx instanceof VertxClientWebSocketResponseToHttpServletResponse)) {
            throw new InvocationException(ExceptionFactory.CONSUMER_INNER_STATUS, "unexpected responseEx type[" + responseEx.getClass() + "], this should be a websocket scene");
        }
        VertxClientWebSocketResponseToHttpServletResponse webSocketResponseEx = (VertxClientWebSocketResponseToHttpServletResponse)responseEx;
        ClientWebSocket clientWebSocket = (ClientWebSocket)invocation.getLocalContext("scb-client-websocket");
        Executor executor = invocation.getOperationMeta().getExecutor();
        VertxWebSocketAdaptor webSocketAdaptor = new VertxWebSocketAdaptor(invocation.getInvocationType(), invocation.getTraceId(), executor, (AbstractBaseWebSocket)clientWebSocket, (WebSocketBase)webSocketResponseEx.getVertxClientWebSocket());
        invocation.addLocalContext("webSocketAdaptor", (Object)webSocketAdaptor);
        if (!invocation.isEdge()) {
            return Response.success(null, (Response.StatusType)responseEx.getStatusType());
        }
        WebSocketPipe webSocketPipe = (WebSocketPipe)invocation.getLocalContext("x-scb-websocket-pipe");
        if (webSocketPipe == null) {
            throw new InvocationException(490, "Unexpected consumer error, please check logs for details", (Object)new CommonExceptionData("SCB.00000000", "edge websocket lost pipe"));
        }
        return Response.success((Object)webSocketPipe.getServerWebSocket(), (Response.StatusType)responseEx.getStatusType());
    }
}

