/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.micrometer.tagged.RateLimiterMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableRateLimiter;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.RateLimitingPolicy;
import org.apache.servicecomb.governance.properties.RateLimitProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingHandler
extends AbstractGovernanceHandler<RateLimiter, RateLimitingPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RateLimitingHandler.class);
    private final RateLimitProperties rateLimitProperties;

    public RateLimitingHandler(RateLimitProperties rateLimitProperties) {
        this.rateLimitProperties = rateLimitProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, RateLimitingPolicy policy) {
        return "servicecomb.rateLimiting." + policy.getName();
    }

    @Override
    public RateLimitingPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (RateLimitingPolicy)this.matchersManager.match(governanceRequest, this.rateLimitProperties.getParsedEntity());
    }

    @Override
    public Disposable<RateLimiter> createProcessor(String key, GovernanceRequest governanceRequest, RateLimitingPolicy policy) {
        return this.getRateLimiter(key, policy);
    }

    private Disposable<RateLimiter> getRateLimiter(String key, RateLimitingPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        RateLimiterConfig config = RateLimiterConfig.custom().limitForPeriod(policy.getRate()).limitRefreshPeriod(Duration.parse(policy.getLimitRefreshPeriod())).timeoutDuration(Duration.parse(policy.getTimeoutDuration())).build();
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of((RateLimiterConfig)config);
        if (this.meterRegistry != null) {
            TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterMetricNames)RateLimiterMetricNames.custom().availablePermissionsMetricName("servicecomb.rateLimiting.available.permissions").waitingThreadsMetricName("servicecomb.rateLimiting.waiting.threads").build(), (RateLimiterRegistry)rateLimiterRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableRateLimiter(key, rateLimiterRegistry.rateLimiter(key), rateLimiterRegistry);
    }
}

