/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.handler.governance;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.governance.MatchType;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.governance.handler.BulkheadHandler;
import org.apache.servicecomb.governance.handler.CircuitBreakerHandler;
import org.apache.servicecomb.governance.handler.RateLimitingHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderGovernanceHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderGovernanceHandler.class);
    private final RateLimitingHandler rateLimitingHandler = (RateLimitingHandler)BeanUtils.getBean(RateLimitingHandler.class);
    private final CircuitBreakerHandler circuitBreakerHandler = (CircuitBreakerHandler)BeanUtils.getBean(CircuitBreakerHandler.class);
    private final BulkheadHandler bulkheadHandler = (BulkheadHandler)BeanUtils.getBean(BulkheadHandler.class);

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        Supplier<CompletionStage<Response>> next = this.createBusinessCompletionStageSupplier(invocation);
        Decorators.DecorateCompletionStage dcs = Decorators.ofCompletionStage(next);
        GovernanceRequest request = MatchType.createGovHttpRequest((Invocation)invocation);
        this.addRateLimiting((Decorators.DecorateCompletionStage<Response>)dcs, request);
        this.addCircuitBreaker((Decorators.DecorateCompletionStage<Response>)dcs, request);
        this.addBulkhead((Decorators.DecorateCompletionStage<Response>)dcs, request);
        dcs.get().whenComplete((r, e) -> {
            if (e == null) {
                asyncResp.complete(r);
                return;
            }
            if (e instanceof RequestNotPermitted) {
                asyncResp.complete(Response.failResp((InvocationException)new InvocationException(429, "rate limited.", (Object)new CommonExceptionData("rate limited."))));
                LOGGER.warn("the request is rate limit by policy : {}", (Object)e.getMessage());
            } else if (e instanceof CallNotPermittedException) {
                asyncResp.complete(Response.failResp((InvocationException)new InvocationException(429, "circuitBreaker is open.", (Object)new CommonExceptionData("circuitBreaker is open."))));
                LOGGER.warn("circuitBreaker is open by policy : {}", (Object)e.getMessage());
            } else if (e instanceof BulkheadFullException) {
                asyncResp.complete(Response.failResp((InvocationException)new InvocationException(429, "bulkhead is full and does not permit further calls.", (Object)new CommonExceptionData("bulkhead is full and does not permit further calls."))));
                LOGGER.warn("bulkhead is full and does not permit further calls by policy : {}", (Object)e.getMessage());
            } else {
                asyncResp.complete(Response.createProducerFail((Throwable)e));
            }
        });
    }

    private void addBulkhead(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequest request) {
        Bulkhead bulkhead = (Bulkhead)this.bulkheadHandler.getActuator(request);
        if (bulkhead != null) {
            dcs.withBulkhead(bulkhead);
        }
    }

    private void addCircuitBreaker(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequest request) {
        CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerHandler.getActuator(request);
        if (circuitBreaker != null) {
            dcs.withCircuitBreaker(circuitBreaker);
        }
    }

    private void addRateLimiting(Decorators.DecorateCompletionStage<Response> dcs, GovernanceRequest request) {
        RateLimiter rateLimiter = (RateLimiter)this.rateLimitingHandler.getActuator(request);
        if (rateLimiter != null) {
            dcs.withRateLimiter(rateLimiter);
        }
    }

    private Supplier<CompletionStage<Response>> createBusinessCompletionStageSupplier(Invocation invocation) {
        return () -> {
            CompletableFuture result = new CompletableFuture();
            try {
                invocation.next(result::complete);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            return result;
        };
    }
}

