/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import com.google.common.collect.ImmutableMap;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.Version;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMicroserviceVersions
extends MicroserviceVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticMicroserviceVersions.class);
    protected final Microservice microservice = new Microservice();
    protected final MicroserviceInstances microserviceInstances = new MicroserviceInstances();

    public StaticMicroserviceVersions(AppManager appManager, String appId, String microserviceName) {
        super(appManager, appId, microserviceName);
    }

    public StaticMicroserviceVersions init(Class<?> schemaIntfCls, String version, List<MicroserviceInstance> instances) {
        return this.init((Map<String, Class<?>>)ImmutableMap.of((Object)this.microserviceName, schemaIntfCls), version, instances);
    }

    public StaticMicroserviceVersions init(Map<String, Class<?>> schemaByIdMap, String version, List<MicroserviceInstance> instances) {
        this.createMicroservice(version);
        this.addSchemas(schemaByIdMap);
        this.addInstances(instances);
        this.pullInstances();
        return this;
    }

    protected void createMicroservice(String version) {
        String environment = RegistrationManager.INSTANCE.getMicroservice().getEnvironment();
        this.microservice.setAppId(this.getAppId());
        this.microservice.setServiceName(this.getShortName());
        this.microservice.setVersion(new Version(version).getVersion());
        this.microservice.setServiceId(this.getAppId() + "-" + environment + "-" + this.getMicroserviceName() + "-" + this.microservice.getVersion());
        this.microservice.setEnvironment(environment);
    }

    protected void addSchemas(Map<String, Class<?>> schemaByIdMap) {
        schemaByIdMap.forEach(this::addSchema);
    }

    protected void addSchema(String schemaId, Class<?> schemaClass) {
        Swagger swagger = RegistrationManager.INSTANCE.getSwaggerLoader().registerSwagger(this.appId, this.shortName, schemaId, schemaClass);
        String swaggerContent = SwaggerUtils.swaggerToString((Swagger)swagger);
        LOGGER.debug("generate swagger for 3rd party service [{}], swagger: {}", (Object)this.microserviceName, (Object)swaggerContent);
        this.microservice.addSchema(schemaId, swaggerContent);
    }

    protected void addInstances(List<MicroserviceInstance> instances) {
        for (int idx = 0; idx < instances.size(); ++idx) {
            MicroserviceInstance instance = instances.get(idx);
            instance.setServiceId(this.microservice.getServiceId());
            instance.setInstanceId(this.microservice.getServiceId() + "-" + idx);
        }
        this.microserviceInstances.setMicroserviceNotExist(false);
        this.microserviceInstances.setInstancesResponse(new FindInstancesResponse());
        this.microserviceInstances.getInstancesResponse().setInstances(instances);
    }

    @Override
    protected MicroserviceInstances findServiceInstances() {
        this.microserviceInstances.setNeedRefresh(this.revision == null);
        this.microserviceInstances.setRevision("1");
        return this.microserviceInstances;
    }

    @Override
    protected MicroserviceVersion createMicroserviceVersion(String microserviceId, List<MicroserviceInstance> instances) {
        return new MicroserviceVersion((MicroserviceVersions)this, this.microservice, this.microserviceName, instances);
    }
}

