/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.extend;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import io.swagger.util.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.foundation.common.base.EnumUtils;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;

public enum SwaggerEnum {
    JDK{

        @Override
        protected <T> T readEnumValue(Field enumField) {
            Enum enumValue = (Enum)EnumUtils.readEnum((Field)enumField);
            return (T)Json.mapper().getSerializationConfig().getAnnotationIntrospector().findEnumValue(enumValue);
        }
    }
    ,
    DYNAMIC{

        @Override
        protected <T> T readEnumValue(Field enumField) {
            DynamicEnum enumValue = (DynamicEnum)EnumUtils.readEnum((Field)enumField);
            return (T)enumValue.getValue();
        }
    };


    public String findPropertyDescription(Class<?> enumClass, Annotation[] annotations) {
        StringBuilder sb = new StringBuilder();
        String propertyDescription = this.readDescription(annotations, null);
        if (StringUtils.isNotEmpty((CharSequence)propertyDescription)) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)propertyDescription, (Object[])new Object[0]);
        }
        EnumUtils.findEnumFields(enumClass).forEach(enumField -> {
            Object enumValue = this.readEnumValue((Field)enumField);
            String description = this.readDescription(enumField.getAnnotations(), "");
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"- %s: %s", (Object[])new Object[]{enumValue, description});
        });
        return sb.toString();
    }

    public <T> List<T> readEnumValues(Class<?> enumClass) {
        return EnumUtils.findEnumFields(enumClass).map(this::readEnumValue).collect(Collectors.toList());
    }

    protected abstract <T> T readEnumValue(Field var1);

    private <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> cls) {
        if (annotations == null) {
            return null;
        }
        return (T)((Annotation)Arrays.stream(annotations).filter(annotation -> cls.isAssignableFrom(annotation.getClass())).map(annotation -> annotation).findAny().orElse(null));
    }

    private String readDescription(Annotation[] annotations, String defaultDescription) {
        ApiModelProperty apiModelProperty = this.findAnnotation(annotations, ApiModelProperty.class);
        if (apiModelProperty != null && StringUtils.isNotEmpty((CharSequence)apiModelProperty.value())) {
            return apiModelProperty.value();
        }
        ApiParam apiParam = this.findAnnotation(annotations, ApiParam.class);
        if (apiParam != null && StringUtils.isNotEmpty((CharSequence)apiParam.value())) {
            return apiParam.value();
        }
        return defaultDescription;
    }
}

