/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.kie.client;

import com.google.common.eventbus.EventBus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.apache.servicecomb.config.kie.client.KieConfigOperation;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequest;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsRequestFactory;
import org.apache.servicecomb.config.kie.client.model.ConfigurationsResponse;
import org.apache.servicecomb.config.kie.client.model.KieAddressManager;
import org.apache.servicecomb.config.kie.client.model.KieConfiguration;
import org.apache.servicecomb.http.client.task.AbstractTask;
import org.apache.servicecomb.http.client.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieConfigManager
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieConfigManager.class);
    private static final long LONG_POLLING_INTERVAL = 1000L;
    private final KieConfigOperation configKieClient;
    private final EventBus eventBus;
    private final ConfigConverter configConverter;
    private final List<ConfigurationsRequest> configurationsRequests;
    private final KieConfiguration kieConfiguration;
    private final KieAddressManager kieAddressManager;

    public KieConfigManager(KieConfigOperation configKieClient, EventBus eventBus, KieConfiguration kieConfiguration, ConfigConverter configConverter, KieAddressManager kieAddressManager) {
        super("config-center-configuration-task");
        this.configurationsRequests = ConfigurationsRequestFactory.buildConfigurationRequests(kieConfiguration);
        this.configurationsRequests.sort(ConfigurationsRequest::compareTo);
        this.configKieClient = configKieClient;
        this.eventBus = eventBus;
        this.configConverter = configConverter;
        this.kieConfiguration = kieConfiguration;
        this.kieAddressManager = kieAddressManager;
    }

    public void firstPull() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            this.firstQueryConfigurations(data);
        }
        catch (Exception e) {
            if (this.kieConfiguration.isFirstPullRequired()) {
                throw e;
            }
            LOGGER.warn("first pull failed!");
        }
    }

    private void firstQueryConfigurations(Map<String, Object> data) {
        for (int i = 0; i < 3; ++i) {
            String address = this.kieAddressManager.address();
            try {
                this.configurationsRequests.forEach(r -> {
                    r.setRevision("-1");
                    ConfigurationsResponse response = this.configKieClient.queryConfigurations((ConfigurationsRequest)r, address);
                    if (response.isChanged()) {
                        r.setRevision(response.getRevision());
                        r.setLastRawData(response.getConfigurations());
                        data.putAll(response.getConfigurations());
                    }
                });
                this.configConverter.updateData(data);
                break;
            }
            catch (Exception e) {
                if (i == 2) {
                    throw e;
                }
                LOGGER.warn("firstQueryConfigurations failed, config address {} and ignore {}", (Object)address, (Object)e.getMessage());
                continue;
            }
        }
    }

    private void onDataChanged() {
        HashMap latestData = new HashMap();
        this.configurationsRequests.forEach(r -> latestData.putAll(r.getLastRawData()));
        Map lastData = this.configConverter.updateData(latestData);
        ConfigurationChangedEvent event = ConfigurationChangedEvent.createIncremental((Map)this.configConverter.getCurrentData(), (Map)lastData);
        if (event.isChanged()) {
            this.eventBus.post((Object)event);
        }
    }

    protected void initTaskPool(String taskName) {
        this.taskPool = Executors.newFixedThreadPool(3, task -> new Thread(task, taskName));
    }

    public void startConfigKieManager() {
        this.configurationsRequests.forEach(t -> this.startTask(new PollConfigurationTask(0, (ConfigurationsRequest)t)));
    }

    class PollConfigurationTask
    implements Task {
        final int failCount;
        ConfigurationsRequest configurationsRequest;

        public PollConfigurationTask(int failCount, ConfigurationsRequest configurationsRequest) {
            this.failCount = failCount;
            this.configurationsRequest = configurationsRequest;
        }

        public void execute() {
            try {
                ConfigurationsResponse response = KieConfigManager.this.configKieClient.queryConfigurations(this.configurationsRequest, KieConfigManager.this.kieAddressManager.address());
                if (response.isChanged()) {
                    this.configurationsRequest.setRevision(response.getRevision());
                    this.configurationsRequest.setLastRawData(response.getConfigurations());
                    KieConfigManager.this.onDataChanged();
                }
                if (KieConfigManager.this.kieConfiguration.isEnableLongPolling()) {
                    KieConfigManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)KieConfigManager.this, 1000L, (Task)new PollConfigurationTask(0, this.configurationsRequest)));
                } else {
                    KieConfigManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)KieConfigManager.this, KieConfigManager.this.kieConfiguration.getRefreshIntervalInMillis(), (Task)new PollConfigurationTask(0, this.configurationsRequest)));
                }
            }
            catch (Exception e) {
                LOGGER.error("get configurations from KieConfigCenter failed, and will try again.", (Throwable)e);
                KieConfigManager.this.startTask((Task)new AbstractTask.BackOffSleepTask((AbstractTask)KieConfigManager.this, this.failCount + 1, (Task)new PollConfigurationTask(this.failCount + 1, this.configurationsRequest)));
            }
        }
    }
}

