/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.http.HttpVersion;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;

public class RegistryHttpClientOptionsSPI
implements HttpClientOptionsSPI {
    public static final String CLIENT_NAME = "registry";
    private final ServiceRegistryConfig serviceRegistryConfig = ServiceRegistryConfig.INSTANCE;

    public String clientName() {
        return CLIENT_NAME;
    }

    public int getOrder() {
        return -100;
    }

    public boolean enabled() {
        return true;
    }

    public String getConfigTag() {
        return "sc.consumer";
    }

    public ConcurrentCompositeConfiguration getConfigReader() {
        return null;
    }

    public int getEventLoopPoolSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.service.registry.client.eventLoopPoolSize", 4).get();
    }

    public boolean useSharedVertx() {
        return false;
    }

    public int getInstanceCount() {
        return this.serviceRegistryConfig.getInstances();
    }

    public boolean isWorker() {
        return false;
    }

    public String getWorkerPoolName() {
        return "pool-worker-service-center-client";
    }

    public int getWorkerPoolSize() {
        return 20;
    }

    public HttpVersion getHttpVersion() {
        return this.serviceRegistryConfig.getHttpVersion();
    }

    public int getConnectTimeoutInMillis() {
        return this.serviceRegistryConfig.getConnectionTimeout();
    }

    public int getIdleTimeoutInSeconds() {
        return this.serviceRegistryConfig.getIdleConnectionTimeout();
    }

    public boolean isTryUseCompression() {
        return false;
    }

    public int getMaxWaitQueueSize() {
        return -1;
    }

    public int getMaxPoolSize() {
        return 5;
    }

    public boolean isKeepAlive() {
        return true;
    }

    public int getMaxHeaderSize() {
        return 8192;
    }

    public int getKeepAliveTimeout() {
        int result = this.getIdleTimeoutInSeconds();
        if (result > 1) {
            return result - 1;
        }
        return result;
    }

    public int getHttp2MultiplexingLimit() {
        return -1;
    }

    public int getHttp2MaxPoolSize() {
        return 1;
    }

    public boolean isUseAlpn() {
        return false;
    }

    public boolean isProxyEnable() {
        return this.serviceRegistryConfig.isProxyEnable();
    }

    public String getProxyHost() {
        return this.serviceRegistryConfig.getProxyHost();
    }

    public int getProxyPort() {
        return this.serviceRegistryConfig.getProxyPort();
    }

    public String getProxyUsername() {
        return this.serviceRegistryConfig.getProxyUsername();
    }

    public String getProxyPassword() {
        return this.serviceRegistryConfig.getProxyPasswd();
    }

    public boolean isSsl() {
        return this.serviceRegistryConfig.isSsl();
    }
}

