/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.transport.AbstractTransport;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.SimpleJsonObject;
import org.apache.servicecomb.foundation.vertx.VertxUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.rest.client.RestTransportClient;
import org.apache.servicecomb.transport.rest.client.RestTransportClientManager;
import org.apache.servicecomb.transport.rest.vertx.TransportConfig;
import org.apache.servicecomb.transport.rest.vertx.VertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxRestTransport
extends AbstractTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRestTransport.class);
    private RestTransportClient restClient;

    public String getName() {
        return "rest";
    }

    public int getOrder() {
        return -1000;
    }

    public boolean canInit() {
        String pattern = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.http.dispatcher.rest.pattern", null).get();
        String urlPrefix = null;
        if (pattern == null || pattern.length() <= 5) {
            this.setListenAddressWithoutSchema(TransportConfig.getAddress());
        } else {
            urlPrefix = pattern.substring(0, pattern.length() - 5);
            this.setListenAddressWithoutSchema(TransportConfig.getAddress(), Collections.singletonMap("urlPrefix", urlPrefix));
        }
        URIEndpointObject ep = (URIEndpointObject)this.getEndpoint().getAddress();
        if (ep == null) {
            return true;
        }
        if (!NetUtils.canTcpListen((InetAddress)ep.getSocketAddress().getAddress(), (int)ep.getPort())) {
            LOGGER.warn("Can not start VertxRestTransport, the port:{} may have been occupied. You can ignore this message if you are using a web container like tomcat.", (Object)ep.getPort());
            return false;
        }
        if (urlPrefix != null) {
            ClassLoaderScopeContext.setClassLoaderScopeProperty((String)"urlPrefix", (String)urlPrefix);
        }
        return true;
    }

    public boolean init() throws Exception {
        this.restClient = RestTransportClientManager.INSTANCE.getRestClient();
        DeploymentOptions options = new DeploymentOptions().setInstances(TransportConfig.getThreadCount());
        SimpleJsonObject json = new SimpleJsonObject();
        json.put("servicecomb.endpoint", (Object)this.getEndpoint());
        json.put(RestTransportClient.class.getName(), (Object)this.restClient);
        options.setConfig((JsonObject)json);
        options.setWorkerPoolName("pool-worker-transport-rest");
        options.setWorkerPoolSize(20);
        this.prepareBlockResource();
        return VertxUtils.blockDeploy((Vertx)this.transportVertx, TransportConfig.getRestServerVerticle(), (DeploymentOptions)options);
    }

    private void prepareBlockResource() {
        List dispatchers = SPIServiceUtils.getOrLoadSortedService(VertxHttpDispatcher.class);
        BeanUtils.addBeans(VertxHttpDispatcher.class, (List)dispatchers);
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        this.restClient.send(invocation, asyncResp);
    }
}

