/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.VendorExtensions;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.event.CreateMicroserviceEvent;
import org.apache.servicecomb.registry.api.event.DestroyMicroserviceEvent;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.registry.config.ServiceRegistryCommonConfig;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceInstancePing;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceVersions.class);
    protected AppManager appManager;
    protected String appId;
    protected String shortName;
    protected String microserviceName;
    protected String revision = null;
    private List<MicroserviceInstance> pulledInstances;
    private MicroserviceInstances lastPulledResult;
    Collection<MicroserviceInstance> instances;
    Map<String, MicroserviceVersion> versions = new ConcurrentHashMapEx();
    Map<String, MicroserviceVersionRule> versionRules = new ConcurrentHashMapEx();
    private final Object lock = new Object();
    private long lastPullTime = 0L;
    private boolean waitingDelete = false;
    private final VendorExtensions vendorExtensions = new VendorExtensions();

    public MicroserviceVersions(AppManager appManager, String appId, String microserviceName) {
        this.appManager = appManager;
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.shortName = new MicroserviceNameParser(appId, microserviceName).getShortName();
        appManager.getEventBus().post((Object)new CreateMicroserviceEvent(this));
        LOGGER.info("create MicroserviceVersions, appId={}, microserviceName={}.", (Object)appId, (Object)microserviceName);
    }

    public boolean isWaitingDelete() {
        return this.waitingDelete;
    }

    public MicroserviceVersions markWaitingDelete() {
        this.waitingDelete = true;
        return this;
    }

    public AppManager getAppManager() {
        return this.appManager;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getShortName() {
        return this.shortName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public Map<String, MicroserviceVersion> getVersions() {
        Object object = this.lock;
        synchronized (object) {
            return this.versions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends MicroserviceVersion> T getVersion(String serviceId) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.versions.get(serviceId);
        }
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public List<MicroserviceInstance> getPulledInstances() {
        return this.pulledInstances;
    }

    public long getLastPullTime() {
        return this.lastPullTime;
    }

    public MicroserviceInstances getLastPulledResult() {
        return this.lastPulledResult;
    }

    public VendorExtensions getVendorExtensions() {
        return this.vendorExtensions;
    }

    public void pullInstances() {
        MicroserviceInstances microserviceInstances;
        this.lastPullTime = System.currentTimeMillis();
        this.lastPulledResult = microserviceInstances = this.findServiceInstances();
        if (microserviceInstances == null) {
            return;
        }
        if (microserviceInstances.isMicroserviceNotExist()) {
            this.waitingDelete = true;
            return;
        }
        if (null != this.revision && this.revision.equals(microserviceInstances.getRevision())) {
            return;
        }
        this.pulledInstances = microserviceInstances.getInstancesResponse().getInstances();
        this.pulledInstances.sort(Comparator.comparing(MicroserviceInstance::getInstanceId));
        String rev = microserviceInstances.getRevision();
        this.safeSetInstances(this.pulledInstances, rev);
    }

    protected MicroserviceInstances findServiceInstances() {
        return DiscoveryManager.INSTANCE.findServiceInstances(this.appId, this.microserviceName, "0.0.0.0+", this.revision);
    }

    protected void safeSetInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        try {
            List<MicroserviceInstance> filteredInstance = pulledInstances;
            if (ServiceRegistryCommonConfig.useUpInstancesOnly()) {
                filteredInstance = pulledInstances.stream().filter(item -> MicroserviceInstanceStatus.UP == item.getStatus()).collect(Collectors.toList());
            }
            this.setInstances(filteredInstance, rev);
        }
        catch (Throwable e) {
            this.waitingDelete = true;
            LOGGER.error("Failed to setInstances, appId={}, microserviceName={}.", new Object[]{this.getAppId(), this.getMicroserviceName(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstances(List<MicroserviceInstance> pulledInstances, String rev) {
        Object object = this.lock;
        synchronized (object) {
            MergedInstances mergedInstances = this.mergeInstances(pulledInstances, this.instances);
            this.instances = mergedInstances.instanceIdMap.values();
            this.versions.forEach((key, value) -> value.setInstances(new ArrayList<MicroserviceInstance>()));
            for (Map.Entry<String, List<MicroserviceInstance>> entry : mergedInstances.microserviceIdMap.entrySet()) {
                MicroserviceVersion newVersion = this.createMicroserviceVersion(entry.getKey(), entry.getValue());
                newVersion.setInstances(entry.getValue());
                this.versions.put(entry.getKey(), newVersion);
            }
            for (MicroserviceVersionRule microserviceVersionRule : this.versionRules.values()) {
                microserviceVersionRule.update(this.versions, this.instances);
            }
            this.revision = rev;
        }
    }

    protected MicroserviceVersion createMicroserviceVersion(String microserviceId, List<MicroserviceInstance> instances) {
        return new MicroserviceVersion(this, microserviceId, this.microserviceName, instances);
    }

    private MergedInstances mergeInstances(List<MicroserviceInstance> pulledInstances, Collection<MicroserviceInstance> inUseInstances) {
        MergedInstances mergedInstances = new MergedInstances();
        pulledInstances.stream().forEach(mergedInstances::addInstance);
        MicroserviceInstancePing ping = (MicroserviceInstancePing)SPIServiceUtils.getPriorityHighestService(MicroserviceInstancePing.class);
        if (pulledInstances.isEmpty() && inUseInstances != null && ServiceRegistryCommonConfig.isEmptyInstanceProtectionEnabled()) {
            inUseInstances.stream().forEach(instance -> {
                if (!mergedInstances.instanceIdMap.containsKey(instance.getInstanceId()) && ping.ping((MicroserviceInstance)instance)) {
                    mergedInstances.addInstance((MicroserviceInstance)instance);
                }
            });
        }
        return mergedInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String versionRule) {
        MicroserviceVersionRule microserviceVersionRule = this.versionRules.get(versionRule);
        if (microserviceVersionRule == null) {
            Object object = this.lock;
            synchronized (object) {
                microserviceVersionRule = this.versionRules.computeIfAbsent(versionRule, this::createAndInitMicroserviceVersionRule);
            }
        }
        return microserviceVersionRule;
    }

    protected MicroserviceVersionRule createAndInitMicroserviceVersionRule(String strVersionRule) {
        LOGGER.info("create MicroserviceVersionRule, appId={}, microserviceName={}, versionRule={}.", new Object[]{this.appId, this.microserviceName, strVersionRule});
        MicroserviceVersionRule microserviceVersionRule = new MicroserviceVersionRule(this.appId, this.microserviceName, strVersionRule);
        microserviceVersionRule.update(this.versions, this.instances);
        return microserviceVersionRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            for (MicroserviceVersion microserviceVersion : this.versions.values()) {
                microserviceVersion.destroy();
            }
        }
        this.appManager.getEventBus().post((Object)new DestroyMicroserviceEvent(this));
    }

    static class MergedInstances {
        Map<String, List<MicroserviceInstance>> microserviceIdMap = new HashMap<String, List<MicroserviceInstance>>();
        Map<String, MicroserviceInstance> instanceIdMap = new HashMap<String, MicroserviceInstance>();

        MergedInstances() {
        }

        void addInstance(MicroserviceInstance instance) {
            this.instanceIdMap.put(instance.getInstanceId(), instance);
            this.microserviceIdMap.computeIfAbsent(instance.getServiceId(), key -> new ArrayList()).add(instance);
        }
    }
}

