/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import io.vertx.core.Vertx;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.executor.SinglePoolBlockingExecutor;
import org.apache.servicecomb.registry.api.MicroserviceKey;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceManager.class);
    private final AppManager appManager;
    private final String appId;
    private final Map<String, MicroserviceVersions> versionsByName = new ConcurrentHashMapEx();
    private final Object lock = new Object();

    public MicroserviceManager(AppManager appManager, String appId) {
        this.appManager = appManager;
        this.appId = appId;
    }

    public Map<String, MicroserviceVersions> getVersionsByName() {
        return this.versionsByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceVersions getOrCreateMicroserviceVersions(String microserviceName) {
        MicroserviceVersions microserviceVersions = this.versionsByName.get(microserviceName);
        if (microserviceVersions == null) {
            Object object = this.lock;
            synchronized (object) {
                microserviceVersions = this.versionsByName.get(microserviceName);
                if (microserviceVersions == null) {
                    microserviceVersions = new MicroserviceVersions(this.appManager, this.appId, microserviceName);
                    microserviceVersions.pullInstances();
                    this.versionsByName.put(microserviceName, microserviceVersions);
                }
            }
        }
        this.tryRemoveInvalidMicroservice(microserviceVersions);
        return microserviceVersions;
    }

    public CompletableFuture<MicroserviceVersions> getOrCreateMicroserviceVersionsAsync(String microserviceName) {
        MicroserviceVersions microserviceVersions = this.versionsByName.get(microserviceName);
        if (microserviceVersions == null) {
            if (Vertx.currentContext() == null) {
                return CompletableFuture.completedFuture(this.getOrCreateMicroserviceVersions(microserviceName));
            }
            return CompletableFuture.supplyAsync(() -> this.getOrCreateMicroserviceVersions(microserviceName), (Executor)SinglePoolBlockingExecutor.create());
        }
        this.tryRemoveInvalidMicroservice(microserviceVersions);
        return CompletableFuture.completedFuture(microserviceVersions);
    }

    private void tryRemoveInvalidMicroservice(MicroserviceVersions microserviceVersions) {
        if (!microserviceVersions.isWaitingDelete()) {
            return;
        }
        String microserviceName = microserviceVersions.getMicroserviceName();
        if (this.versionsByName.remove(microserviceName) != null) {
            microserviceVersions.destroy();
            LOGGER.info("remove microservice, appId={}, microserviceName={}.", (Object)this.appId, (Object)microserviceName);
        }
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String microserviceName, String versionRule) {
        MicroserviceVersions microserviceVersions = this.getOrCreateMicroserviceVersions(microserviceName);
        return microserviceVersions.getOrCreateMicroserviceVersionRule(versionRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullInstances() {
        Object object = this.lock;
        synchronized (object) {
            for (MicroserviceVersions microserviceVersions : this.versionsByName.values()) {
                microserviceVersions.pullInstances();
                this.tryRemoveInvalidMicroservice(microserviceVersions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMicroserviceInstancesChanged(MicroserviceKey microserviceKey) {
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, MicroserviceVersions> item : this.versionsByName.entrySet()) {
                if (!item.getKey().equals(microserviceKey.getServiceName())) continue;
                this.versionsByName.remove(item.getKey());
                item.getValue().destroy();
                LOGGER.info("remove microservice version when instance changed, appId={}, microserviceName={}.", (Object)this.appId, (Object)item.getKey());
            }
        }
    }
}

