/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.refresh;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.util.List;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.http.client.common.AbstractAddressManager;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryAddressManager
extends AbstractAddressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryAddressManager.class);
    private static final String URI_PREFIX = "rest://";

    public ServiceRegistryAddressManager(List<String> addresses, EventBus eventBus) {
        super(addresses);
        eventBus.register((Object)this);
    }

    public IpPort getAvailableIpPort() {
        return this.transformIpPort(this.address());
    }

    protected String normalizeUri(String endpoint) {
        return new URIEndpointObject(endpoint).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean telnetTest(String address) {
        IpPort ipPort = this.transformIpPort(address);
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(ipPort.getHostOrIp(), ipPort.getPort()), 3000);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.warn("ping endpoint {} failed, It will be quarantined again.", (Object)address);
            return false;
        }
    }

    private IpPort transformIpPort(String address) {
        URI uri = URI.create(URI_PREFIX + address);
        return new IpPort(uri.getHost(), uri.getPort());
    }

    @Subscribe
    public void onRefreshEndpointEvent(RefreshEndpointEvent event) {
        this.refreshEndpoint(event, "SERVICECENTER");
    }
}

