/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionToProducerResponseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionToProducerResponseConverters {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionToProducerResponseConverters.class);
    private final Map<Class<?>, ExceptionToProducerResponseConverter<Throwable>> exceptionToProducerResponseConverters = new HashMap();
    private ExceptionToProducerResponseConverter<Throwable> defaultConverter;

    public ExceptionToProducerResponseConverters() {
        SPIServiceUtils.getSortedService(ExceptionToProducerResponseConverter.class).forEach(converter -> {
            if (converter.getExceptionClass() == null) {
                if (this.defaultConverter == null) {
                    this.defaultConverter = converter;
                }
                return;
            }
            this.exceptionToProducerResponseConverters.putIfAbsent(converter.getExceptionClass(), (ExceptionToProducerResponseConverter<Throwable>)converter);
        });
    }

    public Response convertExceptionToResponse(SwaggerInvocation swaggerInvocation, Throwable e) {
        ExceptionToProducerResponseConverter<Throwable> converter = null;
        Class<?> clazz = e.getClass();
        while (converter == null) {
            converter = this.exceptionToProducerResponseConverters.get(clazz);
            if (clazz == Throwable.class) break;
            clazz = clazz.getSuperclass();
        }
        if (converter == null) {
            converter = this.defaultConverter;
        }
        try {
            return converter.convert(swaggerInvocation, e);
        }
        catch (Throwable throwable) {
            LOGGER.error("ExceptionToProducerResponseConverter {} cannot throw exception, please fix it.", converter.getClass(), (Object)throwable);
            return Response.failResp(swaggerInvocation.getInvocationType(), e);
        }
    }
}

