/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableRateLimiter;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.IdentifierRateLimitingPolicy;
import org.apache.servicecomb.governance.properties.IdentifierRateLimitProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierRateLimitingHandler
extends AbstractGovernanceHandler<RateLimiter, IdentifierRateLimitingPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierRateLimitingHandler.class);
    private final IdentifierRateLimitProperties rateLimitProperties;

    public IdentifierRateLimitingHandler(IdentifierRateLimitProperties rateLimitProperties) {
        this.rateLimitProperties = rateLimitProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, IdentifierRateLimitingPolicy policy) {
        if (StringUtils.isEmpty((CharSequence)policy.getIdentifier()) || StringUtils.isEmpty((CharSequence)governanceRequest.getHeader(policy.getIdentifier()))) {
            LOGGER.info("identifier rate limiting is not properly configured, identifier is empty.");
            return null;
        }
        return "servicecomb.identifierRateLimiting." + policy.getName() + "." + governanceRequest.getHeader(policy.getIdentifier());
    }

    @Override
    protected void onConfigurationChanged(String key) {
        if (key.startsWith("servicecomb.identifierRateLimiting")) {
            for (String processorKey : this.processors.keySet()) {
                Disposable processor;
                if (!processorKey.startsWith(key) || (processor = (Disposable)this.processors.remove(processorKey)) == null) continue;
                LOGGER.info("remove identifier rate limiting processor {}", (Object)key);
                processor.dispose();
            }
        }
    }

    @Override
    public IdentifierRateLimitingPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (IdentifierRateLimitingPolicy)this.matchersManager.match(governanceRequest, this.rateLimitProperties.getParsedEntity());
    }

    @Override
    public Disposable<RateLimiter> createProcessor(String key, GovernanceRequest governanceRequest, IdentifierRateLimitingPolicy policy) {
        return this.getRateLimiter(key, policy);
    }

    private Disposable<RateLimiter> getRateLimiter(String key, IdentifierRateLimitingPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        RateLimiterConfig config = RateLimiterConfig.custom().limitForPeriod(policy.getRate()).limitRefreshPeriod(Duration.parse(policy.getLimitRefreshPeriod())).timeoutDuration(Duration.parse(policy.getTimeoutDuration())).build();
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of((RateLimiterConfig)config);
        return new DisposableRateLimiter(key, rateLimiterRegistry.rateLimiter(key), rateLimiterRegistry);
    }
}

