/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.injection;

import io.vavr.CheckedFunction0;
import java.io.Serializable;
import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.injection.FaultInjectionException;
import org.apache.servicecomb.injection.FaultParam;
import org.apache.servicecomb.injection.FaultResponse;

public interface Fault {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Fault fault, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            if (fault.injectFault()) {
                if ("ThrowException".equals(fault.getPolicy().getFallbackType())) {
                    throw new FaultInjectionException(FaultResponse.createFail(fault.getPolicy().getErrorCode(), "aborted by fault inject"));
                }
                return null;
            }
            return supplier.apply();
        };
    }

    public int getOrder();

    public String getName();

    public boolean injectFault();

    public boolean injectFault(FaultParam var1);

    public String getKey();

    public FaultInjectionPolicy getPolicy();
}

