/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableCircuitBreaker;
import org.apache.servicecomb.governance.handler.ext.AbstractCircuitBreakerExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.CircuitBreakerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class CircuitBreakerHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerHandler.class);
    private final CircuitBreakerProperties circuitBreakerProperties;
    private final AbstractCircuitBreakerExtension circuitBreakerExtension;
    private final MeterRegistry meterRegistry;

    public CircuitBreakerHandler(CircuitBreakerProperties circuitBreakerProperties, AbstractCircuitBreakerExtension circuitBreakerExtension, ObjectProvider<MeterRegistry> meterRegistry) {
        this.circuitBreakerProperties = circuitBreakerProperties;
        this.circuitBreakerExtension = circuitBreakerExtension;
        this.meterRegistry = (MeterRegistry)meterRegistry.getIfAvailable();
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return "servicecomb.circuitBreaker." + policy.getName();
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (CircuitBreakerPolicy)this.matchersManager.match(governanceRequest, this.circuitBreakerProperties.getParsedEntity());
    }

    @Override
    public Disposable<CircuitBreaker> createProcessor(String key, GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(key, policy);
    }

    private Disposable<CircuitBreaker> getCircuitBreaker(String key, CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy);
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(policy.getFailureRateThreshold()).slowCallRateThreshold(policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.parse(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.parse(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(Integer.parseInt(policy.getSlidingWindowSize())).recordException(this.circuitBreakerExtension::isFailedResult).recordResult(r -> this.circuitBreakerExtension.isFailedResult(policy.getRecordFailureStatus(), r)).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        if (this.meterRegistry != null) {
            TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableCircuitBreaker(key, circuitBreakerRegistry, circuitBreakerRegistry.circuitBreaker(key, circuitBreakerConfig));
    }
}

