/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.governance.MatchersManager;
import org.apache.servicecomb.governance.event.GovernanceConfigurationChangedEvent;
import org.apache.servicecomb.governance.event.GovernanceEventManager;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableMap;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGovernanceHandler<PROCESSOR, POLICY extends AbstractPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGovernanceHandler.class);
    protected final DisposableMap<PROCESSOR> processors;
    private final Object lock = new Object();
    protected MatchersManager matchersManager;

    protected AbstractGovernanceHandler() {
        GovernanceEventManager.register(this);
        this.processors = new DisposableMap(this::onConfigurationChanged);
    }

    @Autowired
    public void setMatchersManager(MatchersManager matchersManager) {
        this.matchersManager = matchersManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROCESSOR getActuator(GovernanceRequest governanceRequest) {
        POLICY policy = this.matchPolicy(governanceRequest);
        if (policy == null) {
            return null;
        }
        String key = this.createKey(governanceRequest, policy);
        if (key == null) {
            return null;
        }
        Disposable<PROCESSOR> processor = this.processors.get(key);
        if (processor == null) {
            Object object = this.lock;
            synchronized (object) {
                processor = this.processors.get(key);
                if (processor == null) {
                    processor = this.createProcessor(key, governanceRequest, policy);
                    this.processors.put(key, processor);
                }
            }
        }
        return (PROCESSOR)processor.get();
    }

    protected abstract String createKey(GovernanceRequest var1, POLICY var2);

    protected abstract POLICY matchPolicy(GovernanceRequest var1);

    protected abstract Disposable<PROCESSOR> createProcessor(String var1, GovernanceRequest var2, POLICY var3);

    protected void onConfigurationChanged(String key) {
        Disposable processor = (Disposable)this.processors.remove(key);
        if (processor != null) {
            LOGGER.info("remove governance processor {}", (Object)key);
            processor.dispose();
        }
    }

    @Subscribe
    public void onDynamicConfigurationListener(GovernanceConfigurationChangedEvent event) {
        event.getChangedConfigurations().forEach(this::onConfigurationChanged);
    }
}

