/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler.ext;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.ext.FailurePredictor;

public abstract class AbstractFailurePredictor
implements FailurePredictor {
    @Override
    public boolean isFailedResult(List<String> statusList, Object result) {
        String statusCode = this.extractStatusCode(result);
        if (StringUtils.isEmpty((CharSequence)statusCode)) {
            return false;
        }
        return AbstractFailurePredictor.statusCodeContains(statusList, statusCode);
    }

    protected abstract String extractStatusCode(Object var1);

    protected static boolean statusCodeContains(List<String> statusList, String responseStatus) {
        return statusList.stream().anyMatch(status -> AbstractFailurePredictor.statusCodeMatch(status, responseStatus));
    }

    private static boolean statusCodeMatch(String status, String responseStatus) {
        if (3 != status.length()) {
            return false;
        }
        char[] statusChar = status.toCharArray();
        char[] responseChar = responseStatus.toCharArray();
        return IntStream.range(0, 3).noneMatch(i -> statusChar[i] != responseChar[i] && statusChar[i] != 'x');
    }
}

