/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.FaultInjectionPolicy;
import org.apache.servicecomb.governance.properties.FaultInjectionProperties;
import org.apache.servicecomb.injection.Fault;
import org.apache.servicecomb.injection.FaultInjectionUtil;

public class FaultInjectionHandler
extends AbstractGovernanceHandler<Fault, FaultInjectionPolicy> {
    private final FaultInjectionProperties faultInjectionProperties;

    public FaultInjectionHandler(FaultInjectionProperties faultInjectionProperties) {
        this.faultInjectionProperties = faultInjectionProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, FaultInjectionPolicy policy) {
        return "servicecomb.faultInjection." + policy.getName();
    }

    @Override
    public FaultInjectionPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (FaultInjectionPolicy)this.matchersManager.match(governanceRequest, this.faultInjectionProperties.getParsedEntity());
    }

    @Override
    protected Fault createProcessor(String key, GovernanceRequest governanceRequest, FaultInjectionPolicy policy) {
        return FaultInjectionUtil.getFault(key, policy);
    }
}

