/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.BulkheadPolicy;
import org.apache.servicecomb.governance.properties.BulkheadProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkheadHandler
extends AbstractGovernanceHandler<Bulkhead, BulkheadPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkheadHandler.class);
    private final BulkheadProperties bulkheadProperties;

    public BulkheadHandler(BulkheadProperties bulkheadProperties) {
        this.bulkheadProperties = bulkheadProperties;
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, BulkheadPolicy policy) {
        return "servicecomb.bulkhead." + policy.getName();
    }

    @Override
    public BulkheadPolicy matchPolicy(GovernanceRequest governanceRequest) {
        return (BulkheadPolicy)this.matchersManager.match(governanceRequest, this.bulkheadProperties.getParsedEntity());
    }

    @Override
    public Bulkhead createProcessor(String key, GovernanceRequest governanceRequest, BulkheadPolicy policy) {
        return this.getBulkhead(key, policy);
    }

    private Bulkhead getBulkhead(String key, BulkheadPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        BulkheadConfig config = BulkheadConfig.custom().maxConcurrentCalls(policy.getMaxConcurrentCalls()).maxWaitDuration(Duration.parse(policy.getMaxWaitDuration())).build();
        BulkheadRegistry registry = BulkheadRegistry.of((BulkheadConfig)config);
        return registry.bulkhead(key);
    }
}

