/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import com.google.common.collect.Ordering;
import com.netflix.config.DynamicProperty;
import io.github.swagger2markup.Swagger2MarkupConfig;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.builder.Swagger2MarkupConfigBuilder;
import io.swagger.annotations.ApiResponse;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.resource.ClassPathStaticResourceHandler;
import org.apache.servicecomb.common.rest.resource.StaticResourceHandler;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyFactory;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.part.AbstractPart;
import org.apache.servicecomb.foundation.common.part.InputStreamPart;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.model.DynamicPropertyView;
import org.apache.servicecomb.inspector.internal.model.PriorityPropertyView;
import org.apache.servicecomb.inspector.internal.swagger.AppendStyleProcessor;
import org.apache.servicecomb.inspector.internal.swagger.SchemaFormat;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/inspector")
public class InspectorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorImpl.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final StaticResourceHandler resourceHandler = new ClassPathStaticResourceHandler();
    private InspectorConfig inspectorConfig;
    private Map<String, String> schemas;
    private PriorityPropertyFactory propertyFactory;
    private volatile Asciidoctor asciidoctor;

    public InspectorImpl setInspectorConfig(InspectorConfig inspectorConfig) {
        this.inspectorConfig = inspectorConfig;
        return this;
    }

    public InspectorImpl setPropertyFactory(PriorityPropertyFactory propertyFactory) {
        this.propertyFactory = propertyFactory;
        return this;
    }

    public InspectorImpl setSchemas(Map<String, String> schemas) {
        this.schemas = schemas;
        return this;
    }

    public InspectorImpl correctBasePathForOnlineTest(SCBEngine scbEngine) {
        Transport restTransport = scbEngine.getTransportManager().findTransport("rest");
        if (restTransport == null || !restTransport.getClass().getName().equals("org.apache.servicecomb.transport.rest.servlet.ServletRestTransport")) {
            return this;
        }
        String urlPrefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        if (StringUtils.isEmpty((CharSequence)urlPrefix)) {
            return this;
        }
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            Swagger swagger = SwaggerUtils.parseSwagger((String)entry.getValue());
            if (swagger.getBasePath().startsWith(urlPrefix)) continue;
            swagger.setBasePath(urlPrefix + swagger.getBasePath());
            entry.setValue(SwaggerUtils.swaggerToString((Swagger)swagger));
        }
        return this;
    }

    @Path(value="/schemas")
    @GET
    public Collection<String> getSchemaIds() {
        return this.schemas.keySet();
    }

    @Path(value="/download/schemas")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response downloadSchemas(@QueryParam(value="format") SchemaFormat format) {
        if (format == null) {
            format = SchemaFormat.SWAGGER;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(os);){
            for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey() + format.getSuffix()));
                String content = entry.getValue();
                if (SchemaFormat.HTML.equals((Object)format)) {
                    content = this.swaggerToHtml(content);
                }
                zos.write(content.getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
        }
        catch (Throwable e) {
            String msg = "failed to create schemas zip file, format=" + (Object)((Object)format) + ".";
            LOGGER.error(msg, e);
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, msg));
        }
        AbstractPart part = new InputStreamPart(null, (InputStream)new ByteArrayInputStream(os.toByteArray())).setSubmittedFileName(RegistrationManager.INSTANCE.getMicroservice().getServiceName() + format.getSuffix() + ".zip");
        return Response.ok((Object)part);
    }

    @Path(value="/schemas/{schemaId}")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response getSchemaContentById(@PathParam(value="schemaId") String schemaId, @QueryParam(value="format") SchemaFormat format, @QueryParam(value="download") boolean download) {
        byte[] bytes;
        String swaggerContent = this.schemas.get(schemaId);
        if (swaggerContent == null) {
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, Response.Status.NOT_FOUND.getReasonPhrase()));
        }
        if (format == null) {
            format = SchemaFormat.SWAGGER;
        }
        if (SchemaFormat.HTML.equals((Object)format)) {
            String html = this.swaggerToHtml(swaggerContent);
            bytes = html.getBytes(StandardCharsets.UTF_8);
        } else {
            bytes = swaggerContent.getBytes(StandardCharsets.UTF_8);
        }
        AbstractPart part = new InputStreamPart(null, (InputStream)new ByteArrayInputStream(bytes)).setSubmittedFileName(schemaId + format.getSuffix());
        Response response = Response.ok((Object)part);
        if (!download) {
            response.setHeader("Content-Disposition", "inline");
        }
        response.setHeader("Content-Type", "text/html");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String swaggerToHtml(String swaggerContent) {
        if (this.asciidoctor == null) {
            InspectorImpl inspectorImpl = this;
            synchronized (inspectorImpl) {
                if (this.asciidoctor == null) {
                    LOGGER.info("create AsciiDoctor start.");
                    this.asciidoctor = Asciidoctor.Factory.create();
                    this.asciidoctor.javaExtensionRegistry().docinfoProcessor(AppendStyleProcessor.class);
                    LOGGER.info("create AsciiDoctor end.");
                }
            }
        }
        Swagger2MarkupConverter.Builder markupBuilder = Swagger2MarkupConverter.from((Swagger)SwaggerUtils.parseSwagger((String)swaggerContent));
        Swagger2MarkupConfig markupConfig = new Swagger2MarkupConfigBuilder().withParameterOrdering((Comparator)Ordering.explicit((Object)"path", (Object[])new String[]{"query", "header", "cookie", "formData", "body"}).onResultOf(Parameter::getIn)).build();
        String markup = markupBuilder.withConfig(markupConfig).build().toString();
        OptionsBuilder builder = Options.builder();
        builder.docType("book").backend("html5").headerFooter(true).safe(SafeMode.UNSAFE).attributes(Attributes.builder().attribute("toclevels", (Object)3).attribute("toc2", (Object)true).attribute("toc-position", (Object)"left").attribute("linkcss", (Object)true).attribute("stylesheet", (Object)this.inspectorConfig.getAsciidoctorCss()).attribute("numbered", (Object)true).attribute("sectnumlevels", (Object)4).build());
        return this.asciidoctor.convert(markup, builder.build());
    }

    @Path(value="/{path : .+}")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response getStaticResource(@PathParam(value="path") String path) {
        return this.resourceHandler.handle(path);
    }

    @Path(value="/dynamicProperties")
    @GET
    public List<DynamicPropertyView> dynamicProperties() {
        ArrayList<DynamicPropertyView> views = new ArrayList<DynamicPropertyView>();
        for (DynamicProperty property : ConfigUtil.getAllDynamicProperties().values()) {
            views.add(this.createDynamicPropertyView(property));
        }
        views.sort(Comparator.comparing(DynamicPropertyView::getCallbackCount).thenComparing(DynamicPropertyView::getChangedTime).reversed().thenComparing(DynamicPropertyView::getKey));
        return views;
    }

    private DynamicPropertyView createDynamicPropertyView(DynamicProperty property) {
        DynamicPropertyView view = new DynamicPropertyView();
        view.setKey(property.getName());
        view.setValue(property.getString());
        if (property.getChangedTimestamp() != 0L) {
            LocalDateTime localDatetime = LocalDateTime.ofInstant(Instant.ofEpochMilli(property.getChangedTimestamp()), ZoneId.systemDefault());
            view.setChangedTime(localDatetime.format(FORMATTER));
        }
        view.setCallbackCount(ConfigUtil.getCallbacks((DynamicProperty)property).size());
        return view;
    }

    @Path(value="/priorityProperties")
    @GET
    public List<PriorityPropertyView> priorityProperties() {
        ArrayList<PriorityPropertyView> views = new ArrayList<PriorityPropertyView>();
        this.propertyFactory.getProperties().forEach(p -> views.add(this.createPriorityPropertyView((PriorityProperty<?>)p)));
        return views;
    }

    private PriorityPropertyView createPriorityPropertyView(PriorityProperty<?> priorityProperty) {
        PriorityPropertyView view = new PriorityPropertyView();
        view.setDynamicProperties(new ArrayList<DynamicPropertyView>());
        for (DynamicProperty property : priorityProperty.getProperties()) {
            view.getDynamicProperties().add(this.createDynamicPropertyView(property));
        }
        view.setDefaultValue(String.valueOf(priorityProperty.getDefaultValue()));
        view.setValue(String.valueOf(priorityProperty.getValue()));
        return view;
    }
}

