/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.router.model;

import java.util.Map;
import org.apache.servicecomb.router.model.TagItem;

public class RouteItem
implements Comparable<RouteItem> {
    private Integer weight;
    private Integer currentWeight = 0;
    private Map<String, String> tags;
    private TagItem tagitem;

    public void initTagItem() {
        if (this.tags != null && this.tags.containsKey("version")) {
            this.tagitem = new TagItem(this.tags);
        }
    }

    public void addCurrentWeight() {
        this.currentWeight = this.currentWeight + this.weight;
    }

    public void reduceCurrentWeight(int total) {
        this.currentWeight = this.currentWeight - total;
    }

    public RouteItem() {
    }

    public RouteItem(Integer weight, TagItem tags) {
        this.weight = weight;
        this.tagitem = tags;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getCurrentWeight() {
        return this.currentWeight;
    }

    public void setCurrentWeight(Integer currentWeight) {
        this.currentWeight = currentWeight;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public TagItem getTagitem() {
        return this.tagitem;
    }

    public void setTagitem(TagItem tagitem) {
        this.tagitem = tagitem;
    }

    @Override
    public int compareTo(RouteItem param) {
        return Integer.compare(param.weight, this.weight);
    }

    public String toString() {
        return "RouteItem{weight=" + this.weight + ", currentWeight=" + this.currentWeight + ", tags=" + this.tags + ", tagitem=" + this.tagitem + '}';
    }
}

