/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.ext.AbstractInstanceIsolationExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.InstanceIsolationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class InstanceIsolationHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceIsolationHandler.class);
    private final InstanceIsolationProperties instanceIsolationProperties;
    private final AbstractInstanceIsolationExtension isolationExtension;
    private final MeterRegistry meterRegistry;

    public InstanceIsolationHandler(InstanceIsolationProperties instanceIsolationProperties, AbstractInstanceIsolationExtension isolationExtension, ObjectProvider<MeterRegistry> meterRegistry) {
        this.instanceIsolationProperties = instanceIsolationProperties;
        this.isolationExtension = isolationExtension;
        this.meterRegistry = (MeterRegistry)meterRegistry.getIfAvailable();
    }

    @Override
    protected String createKey(GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return "servicecomb.instanceIsolation." + governanceRequest.getServiceName() + "." + policy.getName() + "." + governanceRequest.getInstanceId();
    }

    @Override
    protected void onConfigurationChanged(String key) {
        if (key.startsWith("servicecomb.instanceIsolation")) {
            for (String processorKey : this.processors.keySet()) {
                if (!processorKey.startsWith(key)) continue;
                this.processors.remove(processorKey);
            }
        }
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequest governanceRequest) {
        if (StringUtils.isEmpty((CharSequence)governanceRequest.getServiceName()) || StringUtils.isEmpty((CharSequence)governanceRequest.getInstanceId())) {
            LOGGER.info("Isolation is not properly configured, service id or instance id is empty.");
            return null;
        }
        return (CircuitBreakerPolicy)this.matchersManager.match(governanceRequest, this.instanceIsolationProperties.getParsedEntity());
    }

    @Override
    public CircuitBreaker createProcessor(String key, GovernanceRequest governanceRequest, CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(key, policy);
    }

    private CircuitBreaker getCircuitBreaker(String key, CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy.toString());
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(policy.getFailureRateThreshold()).slowCallRateThreshold(policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.parse(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.parse(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(Integer.parseInt(policy.getSlidingWindowSize())).recordException(this.isolationExtension::isFailedResult).recordResult(r -> this.isolationExtension.isFailedResult(policy.getRecordFailureStatus(), r)).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        if (this.meterRegistry != null) {
            TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry).bindTo(this.meterRegistry);
        }
        return circuitBreakerRegistry.circuitBreaker(key, circuitBreakerConfig);
    }
}

