/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation;

import io.vertx.core.MultiMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class Response {
    private Response.StatusType status;
    private MultiMap headers;
    private Object result;

    public boolean isSucceed() {
        return HttpStatus.isSuccess((Response.StatusType)this.status);
    }

    @Deprecated
    public boolean isSuccessed() {
        return this.isSucceed();
    }

    public boolean isFailed() {
        return !this.isSucceed();
    }

    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.status.getReasonPhrase();
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public void setStatus(Response.StatusType status) {
        this.status = status;
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public List<String> getHeaders(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getAll(name);
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public Response setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    public Response addHeader(String name, String value) {
        if (value == null) {
            return this;
        }
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        this.headers.add(name, value);
        return this;
    }

    public Response setHeader(String name, String value) {
        if (value == null) {
            return this;
        }
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        this.headers.set(name, value);
        return this;
    }

    public <T> T getResult() {
        return (T)this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public static Response create(int statusCode, String reasonPhrase, Object result) {
        HttpStatus status = new HttpStatus(statusCode, reasonPhrase);
        return Response.create((Response.StatusType)status, result);
    }

    public static Response create(Response.StatusType status, Object result) {
        Response response = Response.status(status);
        if (response.isFailed()) {
            result = ExceptionFactory.create(status, result);
        }
        return response.entity(result);
    }

    public static Response createSuccess(Response.StatusType status, Object result) {
        return Response.status(status).entity(result);
    }

    public static Response createSuccess(Object result) {
        return Response.status((Response.StatusType)Response.Status.OK).entity(result);
    }

    public static Response createFail(InvocationException exception) {
        return Response.status(exception.getStatus()).entity(exception);
    }

    public static Response createFail(InvocationType invocationType, String errorMsg) {
        CommonExceptionData errorData = new CommonExceptionData(errorMsg);
        if (InvocationType.CONSUMER.equals((Object)invocationType)) {
            return Response.createFail(ExceptionFactory.createConsumerException((Object)errorData));
        }
        return Response.createFail(ExceptionFactory.createProducerException((Object)errorData));
    }

    public static Response createFail(InvocationType invocationType, Throwable throwable) {
        if (InvocationType.CONSUMER.equals((Object)invocationType)) {
            return Response.createConsumerFail(throwable);
        }
        return Response.createProducerFail(throwable);
    }

    public static Response createConsumerFail(Throwable throwable) {
        InvocationException exception = ExceptionFactory.convertConsumerException(throwable);
        return Response.createFail(exception);
    }

    public static Response createConsumerFail(Throwable throwable, String message) {
        InvocationException exception = ExceptionFactory.convertConsumerException(throwable, message);
        return Response.createFail(exception);
    }

    public static Response createProducerFail(Throwable throwable) {
        InvocationException exception = ExceptionFactory.convertProducerException(throwable);
        return Response.createFail(exception);
    }

    public static Response consumerFailResp(Throwable e) {
        return Response.createConsumerFail(e);
    }

    public static Response producerFailResp(Throwable e) {
        return Response.createProducerFail(e);
    }

    public static Response providerFailResp(Throwable e) {
        return Response.createProducerFail(e);
    }

    public static Response success(Object result, Response.StatusType status) {
        return Response.createSuccess(status, result);
    }

    public static Response succResp(Object result) {
        return Response.createSuccess(result);
    }

    public static Response failResp(InvocationException e) {
        return Response.createFail(e);
    }

    public static Response failResp(InvocationType invocationType, Throwable e) {
        return Response.createFail(invocationType, e);
    }

    public Response entity(Object result) {
        this.setResult(result);
        return this;
    }

    public Response build() {
        return this;
    }

    public static Response status(Response.StatusType status) {
        Response response = new Response();
        response.setStatus(status);
        return response;
    }

    public static Response ok(Object result) {
        Response response = new Response();
        response.setStatus((Response.StatusType)Response.Status.OK);
        response.setResult(result);
        return response;
    }
}

