/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.refresh;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.http.client.event.RefreshEndpointEvent;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.api.registry.DataCenterInfo;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.cache.CacheEndpoint;
import org.apache.servicecomb.registry.cache.InstanceCache;
import org.apache.servicecomb.registry.cache.InstanceCacheManager;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.event.ServiceCenterEventBus;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCache;
import org.apache.servicecomb.serviceregistry.registry.cache.MicroserviceCacheRefreshedEvent;

public class ClassificationAddress {
    private static final String SC_KEY = "SERVICECENTER@default@@0.0.0.0+";
    private static final String CC_KEY = "CseConfigCenter@default@@0.0.0.0+";
    private static final String KIE_KEY = "KIE@default@@0.0.0.0+";
    private static final String MONITORING_KEY = "CseMonitoring@default@@0.0.0.0+";
    private String defaultTransport = "rest";
    private final boolean isAutoRefresh;
    private DataCenterInfo dataCenterInfo;
    InstanceCacheManager instanceCacheManager;
    private final ArrayList<IpPort> defaultIpPort;
    private int maxRetryTimes;

    public ClassificationAddress(ServiceRegistryConfig serviceRegistryConfig, InstanceCacheManager instanceCacheManager) {
        this.defaultTransport = serviceRegistryConfig.getTransport();
        this.defaultIpPort = serviceRegistryConfig.getIpPort();
        this.isAutoRefresh = serviceRegistryConfig.isRegistryAutoRefresh();
        this.instanceCacheManager = instanceCacheManager;
        this.maxRetryTimes = this.defaultIpPort.size();
        ServiceCenterEventBus.getEventBus().register((Object)this);
    }

    public void initEndPoint(String typeName) {
        Map<String, List<String>> zoneAndRegion = this.generateZoneAndRegionAddress(typeName);
        if (zoneAndRegion == null) {
            return;
        }
        EventManager.post((Object)new RefreshEndpointEvent(zoneAndRegion, typeName));
    }

    @Subscribe
    public void onMicroserviceCacheRefreshed(MicroserviceCacheRefreshedEvent event) {
        if (!this.isAutoRefresh) {
            return;
        }
        List<MicroserviceCache> microserviceCaches = event.getMicroserviceCaches();
        if (null == microserviceCaches || microserviceCaches.isEmpty()) {
            return;
        }
        for (MicroserviceCache microserviceCache : microserviceCaches) {
            if (microserviceCache.getKey().toString().equals(SC_KEY)) {
                this.refreshEndPoints(microserviceCache, "SERVICECENTER");
            }
            if (microserviceCache.getKey().toString().equals(CC_KEY)) {
                this.refreshEndPoints(microserviceCache, "KIE");
            }
            if (microserviceCache.getKey().toString().equals(KIE_KEY)) {
                this.refreshEndPoints(microserviceCache, "CseConfigCenter");
            }
            if (!microserviceCache.getKey().toString().equals(MONITORING_KEY)) continue;
            this.refreshEndPoints(microserviceCache, "CseMonitoring");
        }
    }

    private void refreshEndPoints(MicroserviceCache microserviceCache, String name) {
        Map<String, List<String>> zoneAndRegion = this.refreshEndPoint(microserviceCache);
        EventManager.post((Object)new RefreshEndpointEvent(zoneAndRegion, name));
    }

    private Map<String, List<String>> refreshEndPoint(MicroserviceCache microserviceCache) {
        HashSet sameZone = new HashSet();
        HashSet sameRegion = new HashSet();
        HashMap<String, List<String>> zoneAndRegion = new HashMap<String, List<String>>();
        List<MicroserviceInstance> microserviceCacheInstances = microserviceCache.getInstances();
        microserviceCacheInstances.forEach(microserviceInstance -> {
            String endPoint = (String)microserviceInstance.getEndpoints().get(0);
            if (this.regionAndAZMatch(this.dataCenterInfo, (MicroserviceInstance)microserviceInstance)) {
                sameZone.add(endPoint);
            } else {
                sameRegion.add(endPoint);
            }
        });
        zoneAndRegion.put("sameZone", new ArrayList(sameZone));
        zoneAndRegion.put("sameRegion", new ArrayList(sameRegion));
        return zoneAndRegion;
    }

    private Map<String, List<String>> generateZoneAndRegionAddress(String key) {
        List cacheEndpoints;
        InstanceCache kieCaches = this.instanceCacheManager.getOrCreate("default", key, "latest");
        if ("SERVICECENTER".equals(key)) {
            cacheEndpoints = (List)kieCaches.getOrCreateTransportMap().get(this.defaultTransport);
            this.maxRetryTimes = cacheEndpoints.size();
        } else {
            if (kieCaches.getInstanceMap().size() <= 0) {
                return null;
            }
            cacheEndpoints = (List)kieCaches.getOrCreateTransportMap().get(this.defaultTransport);
        }
        HashMap<String, List<String>> zoneAndRegion = new HashMap<String, List<String>>();
        this.dataCenterInfo = this.findRegion(cacheEndpoints);
        HashSet<String> sameZone = new HashSet<String>();
        HashSet<String> sameRegion = new HashSet<String>();
        for (CacheEndpoint cacheEndpoint : cacheEndpoints) {
            if (this.regionAndAZMatch(this.dataCenterInfo, cacheEndpoint.getInstance())) {
                sameZone.add(cacheEndpoint.getEndpoint());
                continue;
            }
            sameRegion.add(cacheEndpoint.getEndpoint());
        }
        zoneAndRegion.put("sameZone", new ArrayList(sameZone));
        zoneAndRegion.put("sameRegion", new ArrayList(sameRegion));
        return zoneAndRegion;
    }

    private DataCenterInfo findRegion(List<CacheEndpoint> CacheEndpoints) {
        for (CacheEndpoint cacheEndpoint : CacheEndpoints) {
            boolean isMatch = cacheEndpoint.getEndpoint().contains(this.defaultIpPort.get(0).getHostOrIp());
            if (!isMatch || cacheEndpoint.getInstance().getDataCenterInfo() == null) continue;
            return cacheEndpoint.getInstance().getDataCenterInfo();
        }
        MicroserviceInstance myself = RegistrationManager.INSTANCE.getMicroserviceInstance();
        if (myself.getDataCenterInfo() == null) {
            return null;
        }
        return myself.getDataCenterInfo();
    }

    private boolean regionAndAZMatch(DataCenterInfo myself, MicroserviceInstance target) {
        if (myself == null) {
            return true;
        }
        if (target.getDataCenterInfo() != null) {
            return myself.getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }
}

