/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.Subscribe;
import io.netty.handler.codec.http.HttpStatusClass;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.foundation.vertx.AsyncResultCallback;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.registry.api.registry.FindInstancesResponse;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.Const;
import org.apache.servicecomb.serviceregistry.api.registry.ServiceCenterInfo;
import org.apache.servicecomb.serviceregistry.api.request.CreateSchemaRequest;
import org.apache.servicecomb.serviceregistry.api.request.CreateServiceRequest;
import org.apache.servicecomb.serviceregistry.api.request.RegisterInstanceRequest;
import org.apache.servicecomb.serviceregistry.api.request.UpdatePropertiesRequest;
import org.apache.servicecomb.serviceregistry.api.response.CreateServiceResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetAllServicesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetExistenceResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetInstancesResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemaResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemasResponse;
import org.apache.servicecomb.serviceregistry.api.response.GetServiceResponse;
import org.apache.servicecomb.serviceregistry.api.response.HeartbeatResponse;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceResponse;
import org.apache.servicecomb.serviceregistry.api.response.RegisterInstanceResponse;
import org.apache.servicecomb.serviceregistry.client.ClientException;
import org.apache.servicecomb.serviceregistry.client.IpPortManager;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.Holder;
import org.apache.servicecomb.serviceregistry.client.http.RequestContext;
import org.apache.servicecomb.serviceregistry.client.http.RequestParam;
import org.apache.servicecomb.serviceregistry.client.http.RestClientUtil;
import org.apache.servicecomb.serviceregistry.client.http.RestResponse;
import org.apache.servicecomb.serviceregistry.client.http.WebsocketClientUtil;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.event.NotPermittedEvent;
import org.apache.servicecomb.serviceregistry.event.ServiceCenterEventBus;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceRegistryClientImpl
implements ServiceRegistryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryClientImpl.class);
    private static final String ERROR_CODE = "errorCode";
    private static final String ERR_SERVICE_NOT_EXISTS = "400012";
    private static final String ERR_SCHEMA_NOT_EXISTS = "400016";
    private final IpPortManager ipPortManager;
    private final Map<String, Boolean> watchServices = new ConcurrentHashMap<String, Boolean>();
    private final RestClientUtil restClientUtil;
    private final WebsocketClientUtil websocketClientUtil;
    private final LoadingCache<String, Map<String, String>> schemaCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(String key) {
            Holder result = ServiceRegistryClientImpl.this.getSchemas(key, true, true);
            HashMap<String, String> schemas = new HashMap<String, String>();
            if (result.getStatusCode() == Response.Status.OK.getStatusCode()) {
                ((List)result.value).stream().forEach(r -> schemas.put(r.getSchemaId(), r.getSchema()));
            }
            return schemas;
        }
    });

    public ServiceRegistryClientImpl(ServiceRegistryConfig serviceRegistryConfig) {
        this.ipPortManager = new IpPortManager(serviceRegistryConfig);
        this.restClientUtil = new RestClientUtil(serviceRegistryConfig);
        this.websocketClientUtil = new WebsocketClientUtil(serviceRegistryConfig);
    }

    @Override
    public void init() {
    }

    private void retry(RequestContext requestContext, Handler<RestResponse> responseHandler) {
        String oldUri = requestContext.getIpPort().toString();
        this.ipPortManager.recordState(oldUri);
        requestContext.setIpPort(this.ipPortManager.getAvailableAddress());
        String newUri = requestContext.getIpPort().toString();
        LOGGER.warn("invoke service [{}] failed, retry address [{}].", (Object)oldUri, (Object)newUri);
        requestContext.incrementRetryTimes();
        this.restClientUtil.httpDo(requestContext, responseHandler);
    }

    @VisibleForTesting
    public <T> Handler<RestResponse> syncHandler(CountDownLatch countDownLatch, Class<T> cls, Holder<T> holder) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandler(countDownLatch, cls, holder));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            holder.setStatusCode(response.statusCode());
            this.sendUnAuthorizedEvent(response);
            response.exceptionHandler(e -> {
                LOGGER.error("error in processing response.", e);
                countDownLatch.countDown();
            });
            response.bodyHandler(bodyBuffer -> {
                if (cls.getName().equals(HttpClientResponse.class.getName())) {
                    holder.value = response;
                    countDownLatch.countDown();
                    return;
                }
                if (cls.equals(String.class)) {
                    holder.setValue(bodyBuffer.toString());
                    countDownLatch.countDown();
                    return;
                }
                if (HttpStatusClass.CLIENT_ERROR.equals((Object)HttpStatusClass.valueOf((int)response.statusCode()))) {
                    try {
                        String errorCode;
                        Map bufferMap = (Map)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), Map.class);
                        if (bufferMap.containsKey(ERROR_CODE) && ((errorCode = (String)bufferMap.get(ERROR_CODE)).equals(ERR_SERVICE_NOT_EXISTS) || errorCode.equals(ERR_SCHEMA_NOT_EXISTS))) {
                            countDownLatch.countDown();
                            return;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("read value failed from buffer {}", bodyBuffer);
                    }
                }
                if (!HttpStatusClass.SUCCESS.equals((Object)HttpStatusClass.valueOf((int)response.statusCode()))) {
                    LOGGER.warn("get response for {} failed, {}:{}, {}", new Object[]{cls.getName(), response.statusCode(), response.statusMessage(), bodyBuffer.toString()});
                    countDownLatch.countDown();
                    return;
                }
                try {
                    holder.value = JsonUtils.readValue((byte[])bodyBuffer.getBytes(), (Class)cls);
                }
                catch (Exception e) {
                    holder.setStatusCode(0).setThrowable(e);
                    LOGGER.warn("read value failed and response message is {}", (Object)bodyBuffer.toString());
                }
                countDownLatch.countDown();
            });
        };
    }

    private Handler<RestResponse> syncHandlerEx(CountDownLatch countDownLatch, Holder<ResponseWrapper> holder) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandlerEx(countDownLatch, holder));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            this.sendUnAuthorizedEvent(response);
            response.exceptionHandler(e -> {
                LOGGER.error("error in processing response.", e);
                countDownLatch.countDown();
            });
            response.bodyHandler(bodyBuffer -> {
                ResponseWrapper responseWrapper = new ResponseWrapper();
                responseWrapper.response = response;
                responseWrapper.bodyBuffer = bodyBuffer;
                holder.value = responseWrapper;
                countDownLatch.countDown();
            });
        };
    }

    private void sendUnAuthorizedEvent(HttpClientResponse response) {
        if (response.statusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
            ServiceCenterEventBus.getEventBus().post((Object)new NotPermittedEvent());
        }
    }

    private Handler<RestResponse> syncHandlerForInstances(CountDownLatch countDownLatch, MicroserviceInstances mInstances) {
        return restResponse -> {
            RequestContext requestContext = restResponse.getRequestContext();
            HttpClientResponse response = restResponse.getResponse();
            if (response == null) {
                if (requestContext.getRetryTimes() <= this.ipPortManager.getMaxRetryTimes()) {
                    this.retry(requestContext, this.syncHandlerForInstances(countDownLatch, mInstances));
                } else {
                    countDownLatch.countDown();
                }
                return;
            }
            response.exceptionHandler(e -> {
                LOGGER.warn("failed to findInstances.", e);
                countDownLatch.countDown();
            });
            response.bodyHandler(bodyBuffer -> {
                try {
                    mInstances.setRevision(response.getHeader("X-Resource-Revision"));
                    switch (response.statusCode()) {
                        case 304: {
                            mInstances.setNeedRefresh(false);
                            break;
                        }
                        case 200: {
                            mInstances.setInstancesResponse((FindInstancesResponse)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), FindInstancesResponse.class));
                            mInstances.setNeedRefresh(true);
                            break;
                        }
                        case 400: {
                            Map error = (Map)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), Map.class);
                            if (ERR_SERVICE_NOT_EXISTS.equals(error.get(ERROR_CODE))) {
                                mInstances.setMicroserviceNotExist(true);
                                mInstances.setNeedRefresh(false);
                            }
                            LOGGER.warn("failed to findInstances: " + bodyBuffer);
                            break;
                        }
                        default: {
                            this.ipPortManager.recordState(requestContext.getIpPort().toString());
                            LOGGER.warn("failed to findInstances: " + bodyBuffer.toString());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("read value failed and response message is {}", (Object)bodyBuffer.toString());
                }
                countDownLatch.countDown();
            });
        };
    }

    @Override
    public List<Microservice> getAllMicroservices() {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.get(ipPort, Const.REGISTRY_API.MICROSERVICE_OPERATION_ALL, new RequestParam(), this.syncHandler(countDownLatch, GetAllServicesResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetAllServicesResponse)holder.value).getServices();
            }
        }
        catch (Exception e) {
            LOGGER.error("query all microservices failed", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    public String getMicroserviceId(String appId, String microserviceName, String versionRule, String environment) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.get(ipPort, Const.REGISTRY_API.MICROSERVICE_EXISTENCE, new RequestParam().addQueryParam("type", "microservice").addQueryParam("appId", appId).addQueryParam("serviceName", microserviceName).addQueryParam("version", versionRule).addQueryParam("env", environment), this.syncHandler(countDownLatch, GetExistenceResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetExistenceResponse)holder.value).getServiceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice id {}/{}/{} fail", new Object[]{appId, microserviceName, versionRule, e});
        }
        return null;
    }

    @Override
    public boolean isSchemaExist(String microserviceId, String schemaId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.get(ipPort, Const.REGISTRY_API.MICROSERVICE_EXISTENCE, new RequestParam().addQueryParam("type", "schema").addQueryParam("serviceId", microserviceId).addQueryParam("schemaId", schemaId), this.syncHandler(countDownLatch, GetExistenceResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query schema exist {}/{} fail", new Object[]{microserviceId, schemaId, e});
        }
        return holder.value != null && schemaId.equals(((GetExistenceResponse)holder.value).getSchemaId());
    }

    @Override
    public boolean registerSchema(String microserviceId, String schemaId, String schemaContent) {
        Holder<ResponseWrapper> holder = new Holder<ResponseWrapper>();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            CreateSchemaRequest request = new CreateSchemaRequest();
            request.setSchema(schemaContent);
            request.setSummary(RegistryUtils.calcSchemaSummary(schemaContent));
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_SCHEMA, microserviceId, schemaId), new RequestParam().setBody(body), this.syncHandlerEx(countDownLatch, holder));
            countDownLatch.await();
            if (holder.value == null) {
                LOGGER.error("Register schema {}/{} failed.", (Object)microserviceId, (Object)schemaId);
                return false;
            }
            if (!Response.Status.Family.SUCCESSFUL.equals((Object)Response.Status.Family.familyOf((int)((ResponseWrapper)holder.value).response.statusCode()))) {
                LOGGER.error("Register schema {}/{} failed, statusCode: {}, statusMessage: {}, description: {}.", new Object[]{microserviceId, schemaId, ((ResponseWrapper)holder.value).response.statusCode(), ((ResponseWrapper)holder.value).response.statusMessage(), ((ResponseWrapper)holder.value).bodyBuffer.toString()});
                return false;
            }
            LOGGER.info("register schema {}/{} success.", (Object)microserviceId, (Object)schemaId);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("register schema {}/{} fail.", new Object[]{microserviceId, schemaId, e});
            return false;
        }
    }

    @Override
    public String getSchema(String microserviceId, String schemaId) {
        return this.doGetSchema(microserviceId, schemaId, false);
    }

    private String doGetSchema(String microserviceId, String schemaId, boolean global) {
        try {
            String cachedSchema = (String)((Map)this.schemaCache.get((Object)microserviceId)).get(schemaId);
            if (cachedSchema != null) {
                return cachedSchema;
            }
        }
        catch (ExecutionException cachedSchema) {
            // empty catch block
        }
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RequestParam param = new RequestParam();
        if (global) {
            param.addQueryParam("global", "true");
        }
        this.restClientUtil.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_SCHEMA, microserviceId, schemaId), param, this.syncHandler(countDownLatch, GetSchemaResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query schema exist {}/{} failed", (Object)schemaId, (Object)e);
        }
        if (holder.value != null) {
            return ((GetSchemaResponse)holder.value).getSchema();
        }
        return null;
    }

    @Override
    public String getAggregatedSchema(String microserviceId, String schemaId) {
        return this.doGetSchema(microserviceId, schemaId, true);
    }

    @Override
    public Holder<List<GetSchemaResponse>> getSchemas(String microserviceId) {
        return this.getSchemas(microserviceId, false, false);
    }

    private Holder<List<GetSchemaResponse>> getSchemas(String microserviceId, boolean withSchema, boolean global) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        Holder<List<GetSchemaResponse>> resultHolder = new Holder<List<GetSchemaResponse>>();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        String url = Const.REGISTRY_API.MICROSERVICE_ALL_SCHEMAs;
        RequestParam requestParam = new RequestParam();
        if (withSchema) {
            url = Const.REGISTRY_API.MICROSERVICE_ALL_SCHEMAs + "?withSchema=1";
        }
        if (global) {
            requestParam.addQueryParam("global", "true");
        }
        this.restClientUtil.get(ipPort, String.format(url, microserviceId), requestParam, this.syncHandler(countDownLatch, GetSchemasResponse.class, holder));
        try {
            countDownLatch.await();
        }
        catch (Exception e) {
            LOGGER.error("query all schemas {} failed", (Object)microserviceId, (Object)e);
        }
        resultHolder.setStatusCode(holder.getStatusCode()).setThrowable(holder.getThrowable());
        if (holder.value != null) {
            return resultHolder.setValue(((GetSchemasResponse)holder.value).getSchema() != null ? ((GetSchemasResponse)holder.value).getSchema() : ((GetSchemasResponse)holder.value).getSchemas());
        }
        return resultHolder;
    }

    @Override
    public String registerMicroservice(Microservice microservice) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            CreateServiceRequest request = new CreateServiceRequest();
            request.setService(microservice);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.post(ipPort, Const.REGISTRY_API.MICROSERVICE_OPERATION_ALL, new RequestParam().setBody(body), this.syncHandler(countDownLatch, CreateServiceResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                return ((CreateServiceResponse)holder.value).getServiceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("register microservice {}/{}/{} failed", new Object[]{microservice.getAppId(), microservice.getServiceName(), microservice.getVersion(), e});
        }
        return null;
    }

    @Override
    public Microservice getMicroservice(String microserviceId) {
        return this.doGetMicroservice(microserviceId, false);
    }

    private Microservice doGetMicroservice(String microserviceId, boolean global) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RequestParam param = new RequestParam();
        if (global) {
            param.addQueryParam("global", "true");
        }
        this.restClientUtil.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_OPERATION_ONE, microserviceId), param, this.syncHandler(countDownLatch, GetServiceResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetServiceResponse)holder.value).getService();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice {} failed", (Object)microserviceId, (Object)e);
        }
        return null;
    }

    @Override
    public Microservice getAggregatedMicroservice(String microserviceId) {
        return this.doGetMicroservice(microserviceId, true);
    }

    @Override
    public String registerMicroserviceInstance(MicroserviceInstance instance) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            RegisterInstanceRequest request = new RegisterInstanceRequest();
            request.setInstance(instance);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.post(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ALL, instance.getServiceId()), new RequestParam().setBody(body), this.syncHandler(countDownLatch, RegisterInstanceResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                return ((RegisterInstanceResponse)holder.value).getInstanceId();
            }
        }
        catch (Exception e) {
            LOGGER.error("register microservice instance {} failed", (Object)instance.getServiceId(), (Object)e);
        }
        return null;
    }

    @Override
    public List<MicroserviceInstance> getMicroserviceInstance(String consumerId, String providerId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ALL, providerId), new RequestParam().addHeader("X-ConsumerId", consumerId), this.syncHandler(countDownLatch, GetInstancesResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return ((GetInstancesResponse)holder.value).getInstances();
            }
        }
        catch (Exception e) {
            LOGGER.error("query microservice instances {} failed", (Object)providerId, (Object)e);
        }
        return null;
    }

    @Override
    public boolean unregisterMicroserviceInstance(String microserviceId, String microserviceInstanceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.delete(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ONE, microserviceId, microserviceInstanceId), new RequestParam(), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("unregister microservice instance {}/{} failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return false;
    }

    @Override
    public HeartbeatResponse heartbeat(String microserviceId, String microserviceInstanceId) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_HEARTBEAT, microserviceId, microserviceInstanceId), new RequestParam().setTimeout(ServiceRegistryConfig.INSTANCE.getHeartBeatRequestTimeout()), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                HeartbeatResponse response = new HeartbeatResponse();
                response.setMessage(((HttpClientResponse)holder.value).statusMessage());
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    response.setOk(true);
                    return response;
                }
                this.ipPortManager.recordState(ipPort.toString());
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
                return response;
            }
        }
        catch (Exception e) {
            LOGGER.error("update microservice instance {}/{} heartbeat failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return null;
    }

    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        this.watch(selfMicroserviceId, callback, (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}), (AsyncResultCallback<Void>)((AsyncResultCallback)v -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void watch(String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback, AsyncResultCallback<Void> onOpen, AsyncResultCallback<Void> onClose) {
        Boolean alreadyWatch = this.watchServices.get(selfMicroserviceId);
        if (alreadyWatch != null) return;
        Class<ServiceRegistryClientImpl> clazz = ServiceRegistryClientImpl.class;
        synchronized (ServiceRegistryClientImpl.class) {
            alreadyWatch = this.watchServices.get(selfMicroserviceId);
            if (alreadyWatch != null) return;
            this.watchServices.put(selfMicroserviceId, true);
            String url = String.format(Const.REGISTRY_API.MICROSERVICE_WATCH, selfMicroserviceId);
            IpPort ipPort = this.ipPortManager.getAvailableAddress();
            this.websocketClientUtil.open(ipPort, url, (Handler<Void>)((Handler)o -> {
                onOpen.success(o);
                LOGGER.info("watching microservice {} successfully, the chosen service center address is {}:{}", new Object[]{selfMicroserviceId, ipPort.getHostOrIp(), ipPort.getPort()});
            }), (Handler<Void>)((Handler)c -> {
                this.watchErrorHandler(new ClientException("connection is closed accidentally"), selfMicroserviceId, callback);
                onClose.success(null);
            }), (Handler<Buffer>)((Handler)bodyBuffer -> {
                MicroserviceInstanceChangedEvent response;
                try {
                    response = (MicroserviceInstanceChangedEvent)JsonUtils.readValue((byte[])bodyBuffer.getBytes(), MicroserviceInstanceChangedEvent.class);
                }
                catch (Exception e) {
                    LOGGER.error("watcher handle microservice {} response failed, {}", (Object)selfMicroserviceId, (Object)bodyBuffer.toString());
                    return;
                }
                try {
                    callback.success((Object)response);
                }
                catch (Exception e) {
                    LOGGER.error("notify watcher failed, microservice {}", (Object)selfMicroserviceId, (Object)e);
                }
            }), (Handler<Throwable>)((Handler)e -> {
                this.watchErrorHandler((Throwable)e, selfMicroserviceId, callback);
                onClose.success(null);
            }), (Handler<Throwable>)((Handler)f -> this.watchErrorHandler((Throwable)f, selfMicroserviceId, callback)));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String consumerId, String appId, String serviceName, String versionRule) {
        MicroserviceInstances instances = this.findServiceInstances(consumerId, appId, serviceName, versionRule, null);
        if (instances == null) {
            return null;
        }
        return instances.getInstancesResponse().getInstances();
    }

    @Override
    public MicroserviceInstances findServiceInstances(String consumerId, String appId, String serviceName, String versionRule, String revision) {
        MicroserviceInstances microserviceInstances = new MicroserviceInstances();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RequestParam requestParam = new RequestParam().addQueryParam("appId", appId).addQueryParam("serviceName", serviceName).addQueryParam("global", "true").addQueryParam("version", versionRule);
        if (RegistryUtils.getMicroservice().getEnvironment() != null) {
            requestParam.addQueryParam("env", RegistryUtils.getMicroservice().getEnvironment());
        }
        if (consumerId != null) {
            requestParam.addHeader("X-ConsumerId", consumerId);
        }
        if (revision != null) {
            requestParam.addQueryParam("rev", revision);
        }
        this.restClientUtil.get(ipPort, Const.REGISTRY_API.MICROSERVICE_INSTANCES, requestParam, this.syncHandlerForInstances(countDownLatch, microserviceInstances));
        try {
            countDownLatch.await();
            if (!microserviceInstances.isNeedRefresh()) {
                return microserviceInstances;
            }
            if (microserviceInstances.getInstancesResponse() == null) {
                return null;
            }
            List list = microserviceInstances.getInstancesResponse().getInstances();
            if (list == null) {
                microserviceInstances.getInstancesResponse().setInstances(new ArrayList());
            }
            return microserviceInstances;
        }
        catch (Exception e) {
            LOGGER.error("find microservice instance {}/{}/{} failed", new Object[]{appId, serviceName, versionRule, e});
            return null;
        }
    }

    private void watchErrorHandler(Throwable e, String selfMicroserviceId, AsyncResultCallback<MicroserviceInstanceChangedEvent> callback) {
        LOGGER.error("watcher connect to service center server failed, microservice {}, {}", (Object)selfMicroserviceId, (Object)e.getMessage());
        callback.fail(e);
        this.watchServices.remove(selfMicroserviceId);
    }

    @Override
    public boolean updateMicroserviceProperties(String microserviceId, Map<String, String> serviceProperties) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            UpdatePropertiesRequest request = new UpdatePropertiesRequest();
            request.setProperties(serviceProperties);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update properties of microservice: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_PROPERTIES, microserviceId), new RequestParam().setBody(body), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("update properties of microservice {} failed", (Object)microserviceId, (Object)e);
        }
        return false;
    }

    @Override
    public boolean updateInstanceProperties(String microserviceId, String microserviceInstanceId, Map<String, String> instanceProperties) {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            UpdatePropertiesRequest request = new UpdatePropertiesRequest();
            request.setProperties(instanceProperties);
            byte[] body = JsonUtils.writeValueAsBytes((Object)request);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("update properties of microservice instance: {}", (Object)new String(body, Charset.defaultCharset()));
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.put(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_PROPERTIES, microserviceId, microserviceInstanceId), new RequestParam().setBody(body), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("update properties of microservice instance {}/{} failed", new Object[]{microserviceId, microserviceInstanceId, e});
        }
        return false;
    }

    @Override
    public MicroserviceInstance findServiceInstance(String serviceId, String instanceId) {
        try {
            Holder holder = new Holder();
            IpPort ipPort = this.ipPortManager.getAvailableAddress();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.get(ipPort, String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_OPERATION_ONE, serviceId, instanceId), new RequestParam().addHeader("X-ConsumerId", serviceId).addQueryParam("global", "true"), this.syncHandler(countDownLatch, MicroserviceInstanceResponse.class, holder));
            countDownLatch.await();
            if (null != holder.value) {
                return ((MicroserviceInstanceResponse)holder.value).getInstance();
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("get instance from sc failed");
            return null;
        }
    }

    @Override
    public ServiceCenterInfo getServiceCenterInfo() {
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.restClientUtil.get(ipPort, Const.REGISTRY_API.SERVICECENTER_VERSION, new RequestParam(), this.syncHandler(countDownLatch, ServiceCenterInfo.class, holder));
        try {
            countDownLatch.await();
            if (holder.value != null) {
                return (ServiceCenterInfo)holder.value;
            }
        }
        catch (Exception e) {
            LOGGER.error("query servicecenter version info failed.", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean updateMicroserviceInstanceStatus(String microserviceId, String instanceId, MicroserviceInstanceStatus status) {
        if (null == status) {
            throw new IllegalArgumentException("null status is now allowed");
        }
        Holder holder = new Holder();
        IpPort ipPort = this.ipPortManager.getAvailableAddress();
        try {
            LOGGER.debug("update status of microservice instance: {}", (Object)status);
            String url = String.format(Const.REGISTRY_API.MICROSERVICE_INSTANCE_STATUS, microserviceId, instanceId);
            HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
            queryParams.put("value", new String[]{status.toString()});
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.restClientUtil.put(ipPort, url, new RequestParam().setQueryParams(queryParams), this.syncHandler(countDownLatch, HttpClientResponse.class, holder));
            countDownLatch.await();
            if (holder.value != null) {
                if (((HttpClientResponse)holder.value).statusCode() == Response.Status.OK.getStatusCode()) {
                    return true;
                }
                LOGGER.warn(((HttpClientResponse)holder.value).statusMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error("update status of microservice instance {}/{} failed", new Object[]{microserviceId, instanceId, e});
        }
        return false;
    }

    @Subscribe
    public void onMicroserviceHeartbeatTask(MicroserviceInstanceHeartbeatTask event) {
        if (HeartbeatResult.SUCCESS.equals((Object)event.getHeartbeatResult())) {
            this.ipPortManager.initAutoDiscovery();
        }
    }

    static class ResponseWrapper {
        HttpClientResponse response;
        Buffer bodyBuffer;

        ResponseWrapper() {
        }
    }
}

