/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.auth;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.servicecomb.foundation.auth.Cipher;
import org.apache.servicecomb.foundation.auth.DefaultCipher;
import org.apache.servicecomb.foundation.bootstrap.BootStrapService;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.auth.DefaultRequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.service.center.client.AddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterClient;
import org.apache.servicecomb.serviceregistry.auth.TokenCacheManager;
import org.springframework.core.env.Environment;

public class RBACBootStrapService
implements BootStrapService {
    private static final String RBAC_ADDRESS = "servicecomb.service.registry.address";
    public static final String DEFAULT_REGISTRY_NAME = "default";
    public static final String RBAC_ENABLED = "servicecomb.credentials.rbac.enabled";
    public static final String ACCOUNT_NAME_KEY = "servicecomb.credentials.account.name";
    public static final String PASSWORD_KEY = "servicecomb.credentials.account.password";
    public static final String CIPHER_KEY = "servicecomb.credentials.cipher";

    public void startup(Environment environment) {
        if (!this.getBooleanProperty(environment, false, RBAC_ENABLED)) {
            return;
        }
        AddressManager addressManager = this.createAddressManager(environment);
        HttpConfiguration.SSLProperties sslProperties = this.createSSLProperties(environment, "sc.consumer");
        sslProperties.setEnabled(addressManager.sslEnabled());
        ServiceCenterClient serviceCenterClient = new ServiceCenterClient(addressManager, sslProperties, (RequestAuthHeaderProvider)new DefaultRequestAuthHeaderProvider(), this.getTenantName(environment), new HashMap(0));
        HashMap<String, ServiceCenterClient> clients = new HashMap<String, ServiceCenterClient>(1);
        clients.put(DEFAULT_REGISTRY_NAME, serviceCenterClient);
        TokenCacheManager.getInstance().setServiceCenterClients(clients);
        TokenCacheManager.getInstance().addTokenCache(DEFAULT_REGISTRY_NAME, this.getStringProperty(environment, null, ACCOUNT_NAME_KEY), this.getStringProperty(environment, null, PASSWORD_KEY), this.getCipher(this.getStringProperty(environment, DEFAULT_REGISTRY_NAME, CIPHER_KEY)));
    }

    @VisibleForTesting
    Cipher getCipher(String cipherName) {
        if (DEFAULT_REGISTRY_NAME.equals(cipherName)) {
            return DefaultCipher.getInstance();
        }
        List ciphers = SPIServiceUtils.getOrLoadSortedService(Cipher.class);
        return ciphers.stream().filter(c -> c.name().equals(cipherName)).findFirst().orElseThrow(() -> new IllegalArgumentException("failed to find cipher named " + cipherName));
    }

    private AddressManager createAddressManager(Environment environment) {
        return new AddressManager(this.getTenantName(environment), this.getRBACAddressList(environment), EventManager.getEventBus());
    }

    private HttpConfiguration.SSLProperties createSSLProperties(Environment environment, String tag) {
        HttpConfiguration.SSLProperties sslProperties = new HttpConfiguration.SSLProperties();
        SSLOption option = new SSLOption();
        option.setEngine(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getEngine(), "ssl." + tag + ".engine", "ssl.engine"));
        option.setProtocols(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getProtocols(), "ssl." + tag + ".protocols", "ssl.protocols"));
        option.setCiphers(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".ciphers", "ssl.ciphers"));
        option.setAuthPeer(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAuthPeer(), "ssl." + tag + ".authPeer", "ssl.authPeer"));
        option.setCheckCNHost(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNHost(), "ssl." + tag + ".checkCN.host", "ssl.checkCN.host"));
        option.setCheckCNWhite(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNWhite(), "ssl." + tag + ".checkCN.white", "ssl.checkCN.white"));
        option.setCheckCNWhiteFile(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".checkCN.white.file", "ssl.checkCN.white.file"));
        option.setAllowRenegociate(this.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAllowRenegociate(), "ssl." + tag + ".allowRenegociate", "ssl.allowRenegociate"));
        option.setStorePath(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getStorePath(), "ssl." + tag + ".storePath", "ssl.storePath"));
        option.setClientAuth(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getClientAuth(), "ssl." + tag + ".clientAuth", "ssl.clientAuth"));
        option.setTrustStore(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStore(), "ssl." + tag + ".trustStore", "ssl.trustStore"));
        option.setTrustStoreType(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreType(), "ssl." + tag + ".trustStoreType", "ssl.trustStoreType"));
        option.setTrustStoreValue(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreValue(), "ssl." + tag + ".trustStoreValue", "ssl.trustStoreValue"));
        option.setKeyStore(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStore(), "ssl." + tag + ".keyStore", "ssl.keyStore"));
        option.setKeyStoreType(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreType(), "ssl." + tag + ".keyStoreType", "ssl.keyStoreType"));
        option.setKeyStoreValue(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreValue(), "ssl." + tag + ".keyStoreValue", "ssl.keyStoreValue"));
        option.setCrl(this.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCrl(), "ssl." + tag + ".crl", "ssl.crl"));
        option.setSslCustomClass(this.getStringProperty(environment, null, "ssl." + tag + ".sslCustomClass", "ssl.sslCustomClass"));
        sslProperties.setSslOption(option);
        sslProperties.setSslCustom(SSLCustom.createSSLCustom((String)option.getSslCustomClass()));
        return sslProperties;
    }

    private String getStringProperty(Environment environment, String defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return environment.getProperty(key);
        }
        return defaultValue;
    }

    private boolean getBooleanProperty(Environment environment, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return Boolean.parseBoolean(environment.getProperty(key));
        }
        return defaultValue;
    }

    private String getTenantName(Environment environment) {
        return environment.getProperty("servicecomb.config.client.tenantName", DEFAULT_REGISTRY_NAME);
    }

    private List<String> getRBACAddressList(Environment environment) {
        String address = environment.getProperty(RBAC_ADDRESS, "http://127.0.0.1:30100)");
        return Arrays.asList(address.split(","));
    }
}

