/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.reference;

import java.lang.reflect.Field;
import org.apache.servicecomb.provider.pojo.RpcReference;
import org.apache.servicecomb.provider.pojo.reference.PojoReferenceMeta;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringValueResolver;

@Component
public class RpcReferenceProcessor
implements BeanPostProcessor,
EmbeddedValueResolverAware {
    private StringValueResolver resolver;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> this.processConsumerField(bean, field));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processConsumerField(Object bean, Field field) {
        RpcReference reference = field.getAnnotation(RpcReference.class);
        if (reference == null) {
            return;
        }
        this.handleReferenceField(bean, field, reference);
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    private void handleReferenceField(Object obj, Field field, RpcReference reference) {
        String microserviceName = reference.microserviceName();
        microserviceName = this.resolver.resolveStringValue(microserviceName);
        PojoReferenceMeta pojoReference = new PojoReferenceMeta();
        pojoReference.setMicroserviceName(microserviceName);
        pojoReference.setSchemaId(reference.schemaId());
        pojoReference.setConsumerIntf(field.getType());
        pojoReference.afterPropertiesSet();
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)obj, (Object)pojoReference.getProxy());
    }
}

