/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.client.http;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientWithContext;
import org.apache.servicecomb.serviceregistry.client.http.RequestParam;
import org.apache.servicecomb.serviceregistry.client.http.WebsocketClientPool;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebsocketClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketClientUtil.class);
    private final WebsocketClientPool websocketClientPool;
    private final List<AuthHeaderProvider> authHeaderProviders;

    WebsocketClientUtil(ServiceRegistryConfig serviceRegistryConfig) {
        this.websocketClientPool = new WebsocketClientPool(serviceRegistryConfig.getWatchClientName());
        this.authHeaderProviders = serviceRegistryConfig.getAuthHeaderProviders();
    }

    public void open(IpPort ipPort, String url, Handler<Void> onOpen, Handler<Void> onClose, Handler<Buffer> onMessage, Handler<Throwable> onException, Handler<Throwable> onConnectFailed) {
        HttpClientWithContext vertxHttpClient = this.websocketClientPool.getClient();
        vertxHttpClient.runOnContext(client -> {
            WebSocketConnectOptions options = new WebSocketConnectOptions();
            options.setHost(ipPort.getHostOrIp()).setPort(Integer.valueOf(ipPort.getPort())).setURI(url).setHeaders(this.getDefaultHeaders().addAll(this.getSignAuthHeaders(this.createSignRequest(HttpMethod.GET.name(), ipPort, new RequestParam(), url, new HashMap<String, String>()))));
            client.webSocket(options, asyncResult -> {
                if (asyncResult.failed()) {
                    onConnectFailed.handle((Object)asyncResult.cause());
                } else {
                    onOpen.handle(null);
                    ((WebSocket)asyncResult.result()).exceptionHandler(v -> {
                        onException.handle(v);
                        try {
                            ((WebSocket)asyncResult.result()).close();
                        }
                        catch (Exception err) {
                            LOGGER.error("ws close error.", (Throwable)err);
                        }
                    });
                    ((WebSocket)asyncResult.result()).closeHandler(v -> onClose.handle(v));
                    ((WebSocket)asyncResult.result()).pongHandler(pong -> {});
                    ((WebSocket)asyncResult.result()).frameHandler(frame -> {
                        if (frame.isBinary() || frame.isText()) {
                            onMessage.handle((Object)frame.binaryData());
                        }
                    });
                }
            });
        });
    }

    public MultiMap getDefaultHeaders() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.defaultHeaders());
    }

    private Map<String, String> defaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", "cse-serviceregistry-client/1.0.0");
        headers.put("x-domain-name", ServiceRegistryConfig.INSTANCE.getTenantName());
        return headers;
    }

    public Map<String, String> getSignAuthHeaders(SignRequest signReq) {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.authHeaderProviders.forEach(provider -> headers.putAll(provider.getSignAuthHeaders(signReq)));
        return headers;
    }

    public SignRequest createSignRequest(String method, IpPort ipPort, RequestParam requestParam, String url, Map<String, String> headers) {
        SignRequest signReq = new SignRequest();
        StringBuilder endpoint = new StringBuilder("https://" + ipPort.getHostOrIp());
        endpoint.append(":" + ipPort.getPort());
        endpoint.append(url);
        try {
            signReq.setEndpoint(new URI(endpoint.toString()));
        }
        catch (URISyntaxException e) {
            LOGGER.error("set uri failed, uri is {}, message: {}", (Object)endpoint.toString(), (Object)e.getMessage());
        }
        signReq.setContent(requestParam.getBody() != null && requestParam.getBody().length > 0 ? new ByteArrayInputStream(requestParam.getBody()) : null);
        signReq.setHeaders(headers);
        signReq.setHttpMethod(method);
        signReq.setQueryParams(requestParam.getQueryParamsMap());
        return signReq;
    }
}

