/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.PolledEvent;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsBootstrap.class);
    private GlobalRegistry globalRegistry;
    private EventBus eventBus;
    private final MetricsBootstrapConfig config = new MetricsBootstrapConfig();
    private ScheduledExecutorService executorService;

    public void start(GlobalRegistry globalRegistry, EventBus eventBus) {
        this.globalRegistry = globalRegistry;
        this.eventBus = eventBus;
        this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("spectator-poller-%d").build());
        this.loadMetricsInitializers();
        this.startPoll();
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        ArrayList initializers = new ArrayList(SPIServiceUtils.getSortedService(MetricsInitializer.class));
        Collections.reverse(initializers);
        initializers.forEach(initializer -> initializer.destroy());
    }

    protected void loadMetricsInitializers() {
        SPIServiceUtils.getSortedService(MetricsInitializer.class).forEach(initializer -> initializer.init(this.globalRegistry, this.eventBus, this.config));
    }

    protected void startPoll() {
        this.executorService.scheduleAtFixedRate(this::pollMeters, 0L, this.config.getMsPollInterval(), TimeUnit.MILLISECONDS);
    }

    public synchronized void pollMeters() {
        try {
            long secondInterval = TimeUnit.MILLISECONDS.toSeconds(this.config.getMsPollInterval());
            PolledEvent polledEvent = this.globalRegistry.poll(secondInterval);
            this.eventBus.post((Object)polledEvent);
        }
        catch (Throwable e) {
            LOGGER.error("poll meters error. ", e);
        }
    }
}

