/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.marker;

import java.util.Map;
import org.apache.servicecomb.governance.marker.GovernanceRequest;
import org.apache.servicecomb.governance.marker.Matcher;
import org.apache.servicecomb.governance.marker.operator.MatchOperator;
import org.apache.servicecomb.governance.marker.operator.RawOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProcessor.class);
    private static final String OPERATOR_SUFFIX = "Operator";
    private final Map<String, MatchOperator> operatorMap;

    public RequestProcessor(Map<String, MatchOperator> operatorMap) {
        this.operatorMap = operatorMap;
    }

    public boolean match(GovernanceRequest request, Matcher matcher) {
        if (matcher.getMethod() != null && !matcher.getMethod().contains(request.getMethod()) || matcher.getApiPath() != null && !this.operatorMatch(request.getUri(), matcher.getApiPath())) {
            return false;
        }
        if (matcher.getHeaders() == null) {
            return true;
        }
        for (Map.Entry<String, RawOperator> entry : matcher.getHeaders().entrySet()) {
            if (request.getHeaders().containsKey(entry.getKey()) && this.operatorMatch(request.getHeaders().get(entry.getKey()), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean operatorMatch(String str, RawOperator rawOperator) {
        if (rawOperator.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : rawOperator.entrySet()) {
            MatchOperator operator = this.operatorMap.get((String)entry.getKey() + OPERATOR_SUFFIX);
            if (operator == null) {
                LOGGER.error("unsupported operator:" + (String)entry.getKey() + ", plz use one of :" + this.operatorMap.keySet().toString());
                return false;
            }
            if (operator.match(str, (String)entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

