/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.cpu;

import com.netflix.spectator.api.Id;
import java.io.IOException;
import org.apache.servicecomb.metrics.core.meter.os.cpu.AbstractCpuUsage;
import org.apache.servicecomb.metrics.core.meter.os.cpu.CpuUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCpuUsage
extends AbstractCpuUsage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessCpuUsage.class);
    private final AbstractCpuUsage.Period busy = new AbstractCpuUsage.Period();
    private final AbstractCpuUsage.Period total = new AbstractCpuUsage.Period();
    private final int userHZ = CpuUtils.calcHertz();

    public ProcessCpuUsage(Id id) {
        super(id);
    }

    public void update() throws IOException {
        double processBusy = CpuUtils.readProcSelfBusy();
        double uptime = CpuUtils.readUptimeTotal();
        this.busy.update(processBusy);
        this.total.update(uptime * (double)this.userHZ * (double)this.cpuCount);
        this.updateUsage(this.busy.period, this.total.period, true);
    }
}

