/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.DynamicPropertyFactory;
import io.vertx.core.json.jackson.JacksonFactory;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.foundation.common.event.EnableExceptionPropagation;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.foundation.common.utils.SPIEnabled;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.Registration;
import org.apache.servicecomb.registry.api.event.MicroserviceInstanceRegisteredEvent;
import org.apache.servicecomb.registry.api.registry.BasePath;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.consumer.MicroserviceManager;
import org.apache.servicecomb.registry.consumer.StaticMicroserviceVersions;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.apache.servicecomb.registry.swagger.SwaggerLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistrationManager.class);
    public static final String PUBLISH_ADDRESS = "servicecomb.service.publishAddress";
    private static final String PUBLISH_PORT = "servicecomb.{transport_name}.publishPort";
    private static final SwaggerLoader swaggerLoader = new SwaggerLoader();
    public static RegistrationManager INSTANCE = new RegistrationManager();
    private final List<Registration> registrationList = new ArrayList<Registration>();
    private Registration primary;

    private RegistrationManager() {
        SPIServiceUtils.getOrLoadSortedService(Registration.class).stream().filter(SPIEnabled::enabled).forEach(this.registrationList::add);
        this.initPrimary();
    }

    public MicroserviceInstance getMicroserviceInstance() {
        return this.primary.getMicroserviceInstance();
    }

    public Microservice getMicroservice() {
        this.assertPrimaryNotNull();
        return this.primary.getMicroservice();
    }

    private void assertPrimaryNotNull() {
        if (this.primary == null) {
            throw new NullPointerException("At least one Registration implementation configured. Missed to include dependency ? e.g. <artifactId>registry-service-center</artifactId>");
        }
    }

    public String getAppId() {
        this.assertPrimaryNotNull();
        return this.primary.getAppId();
    }

    public SwaggerLoader getSwaggerLoader() {
        return swaggerLoader;
    }

    public void updateMicroserviceInstanceStatus(MicroserviceInstanceStatus status) {
        this.registrationList.forEach(registration -> registration.updateMicroserviceInstanceStatus(status));
    }

    public void addSchema(String schemaId, String content) {
        this.registrationList.forEach(registration -> registration.addSchema(schemaId, content));
    }

    public void addEndpoint(String endpoint) {
        this.registrationList.forEach(registration -> registration.addEndpoint(endpoint));
    }

    public void addBasePath(Collection<BasePath> basePaths) {
        this.registrationList.forEach(registration -> registration.addBasePath(basePaths));
    }

    public void destroy() {
        this.registrationList.forEach(registration -> registration.destroy());
    }

    public void run() {
        EventManager.getEventBus().register((Object)new AfterServiceInstanceRegistryHandler(this.registrationList.size()));
        this.registrationList.forEach(registration -> registration.run());
    }

    public void init() {
        BeanUtils.addBeans(Registration.class, this.registrationList);
        this.initPrimary();
        this.registrationList.forEach(registration -> registration.init());
    }

    private void initPrimary() {
        if (this.registrationList.isEmpty()) {
            LOGGER.warn("No registration is enabled. Fix this if only in unit tests.");
            this.primary = null;
        } else {
            this.primary = this.registrationList.get(0);
        }
    }

    public void registerMicroserviceMapping(String microserviceName, String version, List<MicroserviceInstance> instances, Class<?> schemaIntfCls) {
        MicroserviceNameParser parser = new MicroserviceNameParser(this.getAppId(), microserviceName);
        MicroserviceManager microserviceManager = DiscoveryManager.INSTANCE.getAppManager().getOrCreateMicroserviceManager(parser.getAppId());
        microserviceManager.getVersionsByName().computeIfAbsent(microserviceName, svcName -> new StaticMicroserviceVersions(DiscoveryManager.INSTANCE.getAppManager(), parser.getAppId(), microserviceName).init(schemaIntfCls, version, instances));
    }

    public void registerMicroserviceMappingByEndpoints(String microserviceName, String version, List<String> endpoints, Class<?> schemaIntfCls) {
        ArrayList<MicroserviceInstance> microserviceInstances = new ArrayList<MicroserviceInstance>();
        for (String endpoint : endpoints) {
            MicroserviceInstance instance = new MicroserviceInstance();
            instance.setEndpoints(Collections.singletonList(endpoint));
            microserviceInstances.add(instance);
        }
        this.registerMicroserviceMapping(microserviceName, version, microserviceInstances, schemaIntfCls);
    }

    public static String getPublishAddress() {
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        if ((publicAddressSetting = publicAddressSetting.trim()).isEmpty()) {
            return NetUtils.getHostAddress();
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            return NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostAddress();
        }
        return publicAddressSetting;
    }

    public static String getPublishHostName() {
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        if ((publicAddressSetting = publicAddressSetting.trim()).isEmpty()) {
            return NetUtils.getHostName();
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            return NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostName();
        }
        return publicAddressSetting;
    }

    public static String getPublishAddress(String schema, String address) {
        if (address == null) {
            return address;
        }
        try {
            URI originalURI = new URI(schema + "://" + address);
            IpPort ipPort = NetUtils.parseIpPort((URI)originalURI);
            if (ipPort == null) {
                LOGGER.warn("address {} not valid.", (Object)address);
                return null;
            }
            IpPort publishIpPort = RegistrationManager.genPublishIpPort(schema, ipPort);
            URIBuilder builder = new URIBuilder(originalURI);
            return builder.setHost(publishIpPort.getHostOrIp()).setPort(publishIpPort.getPort()).build().toString();
        }
        catch (URISyntaxException e) {
            LOGGER.warn("address {} not valid.", (Object)address);
            return null;
        }
    }

    private static IpPort genPublishIpPort(String schema, IpPort ipPort) {
        int publishPort;
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        publicAddressSetting = publicAddressSetting.trim();
        String publishPortKey = PUBLISH_PORT.replace("{transport_name}", schema);
        int publishPortSetting = DynamicPropertyFactory.getInstance().getIntProperty(publishPortKey, 0).get();
        int n = publishPort = publishPortSetting == 0 ? ipPort.getPort() : publishPortSetting;
        if (publicAddressSetting.isEmpty()) {
            InetSocketAddress socketAddress = ipPort.getSocketAddress();
            if (socketAddress.getAddress().isAnyLocalAddress()) {
                String host = NetUtils.getHostAddress();
                if (Inet6Address.class.isInstance(socketAddress.getAddress())) {
                    host = NetUtils.getIpv6HostAddress();
                }
                LOGGER.warn("address {}, auto select a host address to publish {}:{}, maybe not the correct one", new Object[]{socketAddress, host, publishPort});
                return new IpPort(host, publishPort);
            }
            return ipPort;
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            publicAddressSetting = NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostAddress();
        }
        return new IpPort(publicAddressSetting, publishPort);
    }

    public String info() {
        StringBuilder result = new StringBuilder();
        AtomicBoolean first = new AtomicBoolean(true);
        this.registrationList.forEach(registration -> {
            if (first.getAndSet(false)) {
                result.append("App ID: " + registration.getAppId() + "\n");
                result.append("Service Name: " + registration.getMicroservice().getServiceName() + "\n");
                result.append("Version: " + registration.getMicroservice().getVersion() + "\n");
                result.append("Environment: " + registration.getMicroservice().getEnvironment() + "\n");
                result.append("Endpoints: " + this.getEndpoints(registration.getMicroserviceInstance().getEndpoints()) + "\n");
                result.append("Registration implementations:\n");
            }
            result.append("  name:" + registration.name() + "\n");
            result.append("    Service ID: " + registration.getMicroservice().getServiceId() + "\n");
            result.append("    Instance ID: " + registration.getMicroserviceInstance().getInstanceId() + "\n");
        });
        return result.toString();
    }

    private String getEndpoints(List<String> endpoints) {
        return JacksonFactory.CODEC.toString(endpoints);
    }

    public static class AfterServiceInstanceRegistryHandler {
        private final AtomicInteger instanceRegisterCounter;

        AfterServiceInstanceRegistryHandler(int counter) {
            this.instanceRegisterCounter = new AtomicInteger(counter);
        }

        @Subscribe
        @EnableExceptionPropagation
        public void afterRegistryInstance(MicroserviceInstanceRegisteredEvent event) {
            LOGGER.info("receive MicroserviceInstanceRegisteredEvent event, registration={}, instance id={}", (Object)event.getRegistrationName(), (Object)event.getInstanceId());
            if (this.instanceRegisterCounter.decrementAndGet() > 0) {
                return;
            }
            EventManager.unregister((Object)this);
            EventManager.getEventBus().post((Object)new MicroserviceInstanceRegisteredEvent("Registration Manager", null, true));
        }
    }
}

