/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core;

import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.event.InvocationBusinessFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationEncodeResponseStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationHandlersStartEvent;
import org.apache.servicecomb.core.event.InvocationRunInExecutorFinishEvent;
import org.apache.servicecomb.core.event.InvocationRunInExecutorStartEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.core.event.InvocationStartSendRequestEvent;
import org.apache.servicecomb.core.event.InvocationTimeoutCheckEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.apache.servicecomb.core.tracing.TraceIdGenerator;
import org.apache.servicecomb.core.tracing.TraceIdLogger;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class Invocation
extends SwaggerInvocation {
    private static final Collection<TraceIdGenerator> TRACE_ID_GENERATORS = Invocation.loadTraceIdGenerators();
    protected static final AtomicLong INVOCATION_ID = new AtomicLong();
    protected ReferenceConfig referenceConfig;
    private InvocationRuntimeType invocationRuntimeType;
    private SchemaMeta schemaMeta;
    private OperationMeta operationMeta;
    private Endpoint endpoint;
    private final Map<String, Object> handlerContext;
    private List<Handler> handlerList;
    private int handlerIndex;
    private Executor responseExecutor;
    private boolean sync;
    private final InvocationStageTrace invocationStageTrace;
    private HttpServletRequestEx requestEx;
    private boolean finished;
    private boolean edge;
    private long invocationId;
    private TraceIdLogger traceIdLogger;
    private Map<String, Object> invocationArguments;
    private Object[] producerArguments;
    private Map<String, Object> swaggerArguments;

    static Collection<TraceIdGenerator> loadTraceIdGenerators() {
        return SPIServiceUtils.getPriorityHighestServices(TraceIdGenerator::getName, TraceIdGenerator.class);
    }

    public Invocation() {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
        this.invocationArguments = Collections.emptyMap();
        this.swaggerArguments = Collections.emptyMap();
        this.traceIdLogger = new TraceIdLogger(this);
    }

    public Invocation(ReferenceConfig referenceConfig, OperationMeta operationMeta, InvocationRuntimeType invocationRuntimeType, Map<String, Object> swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
        this.invocationArguments = Collections.emptyMap();
        this.swaggerArguments = Collections.emptyMap();
        this.invocationType = InvocationType.CONSUMER;
        this.referenceConfig = referenceConfig;
        this.invocationRuntimeType = invocationRuntimeType;
        this.init(operationMeta, swaggerArguments);
    }

    public Invocation(Endpoint endpoint, OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        this.handlerContext = this.localContext;
        this.sync = true;
        this.invocationStageTrace = new InvocationStageTrace(this);
        this.invocationArguments = Collections.emptyMap();
        this.swaggerArguments = Collections.emptyMap();
        this.invocationType = InvocationType.PRODUCER;
        this.invocationRuntimeType = operationMeta.buildBaseProviderRuntimeType();
        this.endpoint = endpoint;
        this.init(operationMeta, swaggerArguments);
    }

    private void init(OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        this.invocationId = INVOCATION_ID.getAndIncrement();
        this.schemaMeta = operationMeta.getSchemaMeta();
        this.operationMeta = operationMeta;
        this.setSwaggerArguments(swaggerArguments);
        this.handlerList = this.getHandlerChain();
        this.handlerIndex = 0;
        this.traceIdLogger = new TraceIdLogger(this);
    }

    public Transport getTransport() {
        if (this.endpoint == null) {
            throw new IllegalStateException("Endpoint is empty. Forget to configure \"loadbalance\" in consumer handler chain?");
        }
        return this.endpoint.getTransport();
    }

    public List<Handler> getHandlerChain() {
        return this.schemaMeta.getMicroserviceMeta().getHandlerChain();
    }

    public Executor getResponseExecutor() {
        return this.responseExecutor;
    }

    public void setResponseExecutor(Executor responseExecutor) {
        this.responseExecutor = responseExecutor;
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public Map<String, Object> getInvocationArguments() {
        return this.invocationArguments;
    }

    public Map<String, Object> getSwaggerArguments() {
        return this.swaggerArguments;
    }

    public Object getInvocationArgument(String name) {
        return this.invocationArguments.get(name);
    }

    public Object getSwaggerArgument(String name) {
        return this.swaggerArguments.get(name);
    }

    public void setInvocationArguments(Map<String, Object> invocationArguments) {
        if (invocationArguments == null) {
            this.invocationArguments = new HashMap<String, Object>(0);
            return;
        }
        this.invocationArguments = invocationArguments;
        this.buildSwaggerArguments();
    }

    private void buildSwaggerArguments() {
        this.swaggerArguments = !this.invocationRuntimeType.isRawConsumer() ? this.invocationRuntimeType.getArgumentsMapper().invocationArgumentToSwaggerArguments((SwaggerInvocation)this, this.invocationArguments) : this.invocationArguments;
    }

    public void setSwaggerArguments(Map<String, Object> swaggerArguments) {
        if (swaggerArguments == null) {
            this.swaggerArguments = new HashMap<String, Object>(0);
            return;
        }
        this.swaggerArguments = swaggerArguments;
        this.buildInvocationArguments();
    }

    private void buildInvocationArguments() {
        this.invocationArguments = this.operationMeta.getSwaggerProducerOperation() != null && !this.isEdge() ? this.operationMeta.getSwaggerProducerOperation().getArgumentsMapper().swaggerArgumentToInvocationArguments((SwaggerInvocation)this, this.swaggerArguments) : this.swaggerArguments;
    }

    public Object[] toProducerArguments() {
        if (this.producerArguments != null) {
            return this.producerArguments;
        }
        Method method = this.operationMeta.getSwaggerProducerOperation().getProducerMethod();
        Object[] args = new Object[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            args[i] = this.invocationArguments.get(method.getParameters()[i].getName());
        }
        this.producerArguments = args;
        return args;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getHandlerContext() {
        return this.handlerContext;
    }

    public int getHandlerIndex() {
        return this.handlerIndex;
    }

    public void setHandlerIndex(int handlerIndex) {
        this.handlerIndex = handlerIndex;
    }

    public void next(AsyncResponse asyncResp) throws Exception {
        int runIndex = this.handlerIndex++;
        this.handlerList.get(runIndex).handle(this, asyncResp);
    }

    public String getSchemaId() {
        return this.schemaMeta.getSchemaId();
    }

    public String getOperationName() {
        return this.operationMeta.getOperationId();
    }

    public String getConfigTransportName() {
        return this.referenceConfig.getTransport();
    }

    public String getRealTransportName() {
        return this.endpoint != null ? this.endpoint.getTransport().getName() : this.getConfigTransportName();
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public String getAppId() {
        return this.schemaMeta.getMicroserviceMeta().getAppId();
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public String getMicroserviceVersionRule() {
        return this.referenceConfig.getVersionRule();
    }

    public InvocationRuntimeType getInvocationRuntimeType() {
        return this.invocationRuntimeType;
    }

    public JavaType findResponseType(int statusCode) {
        return this.invocationRuntimeType.findResponseType(statusCode);
    }

    public void setSuccessResponseType(JavaType javaType) {
        this.invocationRuntimeType.setSuccessResponseType(javaType);
    }

    public String getInvocationQualifiedName() {
        return this.invocationType.name() + " " + this.getRealTransportName() + " " + this.getOperationMeta().getMicroserviceQualifiedName();
    }

    public String getMicroserviceQualifiedName() {
        return this.operationMeta.getMicroserviceQualifiedName();
    }

    protected void initTraceId() {
        for (TraceIdGenerator traceIdGenerator : TRACE_ID_GENERATORS) {
            this.initTraceId(traceIdGenerator);
        }
    }

    protected void initTraceId(TraceIdGenerator traceIdGenerator) {
        if (!StringUtils.isEmpty((CharSequence)this.getTraceId(traceIdGenerator.getTraceIdKeyName()))) {
            return;
        }
        if (this.requestEx == null) {
            this.addContext(traceIdGenerator.getTraceIdKeyName(), traceIdGenerator.generate());
            return;
        }
        String traceId = this.requestEx.getHeader(traceIdGenerator.getTraceIdKeyName());
        if (!StringUtils.isEmpty((CharSequence)traceId)) {
            this.addContext(traceIdGenerator.getTraceIdKeyName(), traceId);
            return;
        }
        this.addContext(traceIdGenerator.getTraceIdKeyName(), traceIdGenerator.generate());
    }

    public void onStart(long start) {
        this.invocationStageTrace.start(start);
        this.initTraceId();
        EventManager.post((Object)new InvocationStartEvent(this));
    }

    public void onStart(HttpServletRequestEx requestEx, long start) {
        this.requestEx = requestEx;
        this.onStart(start);
    }

    public void onExecuteStart() {
        this.invocationStageTrace.startExecution();
        EventManager.post((Object)new InvocationRunInExecutorStartEvent(this));
    }

    public void onExecuteFinish() {
        EventManager.post((Object)new InvocationRunInExecutorFinishEvent(this));
    }

    public void onStartHandlersRequest() {
        this.invocationStageTrace.startHandlersRequest();
        EventManager.post((Object)new InvocationHandlersStartEvent(this));
    }

    public void onStartSendRequest() {
        this.invocationStageTrace.startSend();
        EventManager.post((Object)new InvocationStartSendRequestEvent(this));
    }

    public void onBusinessMethodStart() {
        this.invocationStageTrace.startBusinessMethod();
        EventManager.post((Object)new InvocationBusinessMethodStartEvent(this));
    }

    public void onBusinessMethodFinish() {
        EventManager.post((Object)new InvocationBusinessMethodFinishEvent(this));
    }

    public void onEncodeResponseStart(Response response) {
        EventManager.post((Object)new InvocationEncodeResponseStartEvent(this, response));
    }

    public void onBusinessFinish() {
        this.invocationStageTrace.finishBusiness();
        EventManager.post((Object)new InvocationBusinessFinishEvent(this));
    }

    public void onFinish(Response response) {
        if (this.finished) {
            return;
        }
        this.invocationStageTrace.finish();
        EventManager.post((Object)new InvocationFinishEvent(this, response));
        this.finished = true;
    }

    public void reset() {
        this.finished = false;
        this.handlerIndex = 0;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isConsumer() {
        return InvocationType.CONSUMER.equals((Object)this.invocationType);
    }

    public boolean isProducer() {
        return InvocationType.PRODUCER.equals((Object)this.invocationType);
    }

    public boolean isEdge() {
        return this.edge;
    }

    public void setEdge(boolean edge) {
        this.edge = edge;
    }

    public boolean isThirdPartyInvocation() {
        return this.referenceConfig.is3rdPartyService();
    }

    public long getInvocationId() {
        return this.invocationId;
    }

    public TraceIdLogger getTraceIdLogger() {
        return this.traceIdLogger;
    }

    public HttpServletRequestEx getRequestEx() {
        return this.requestEx;
    }

    public InvocationStageTrace getInvocationStageTrace() {
        return this.invocationStageTrace;
    }

    public String getTraceId() {
        return this.getContext("X-B3-TraceId");
    }

    public String getTraceId(String traceIdName) {
        return this.getContext(traceIdName);
    }

    public <T> CompletableFuture<T> optimizeSyncConsumerThread(CompletableFuture<T> future) {
        if (this.sync && !InvokerUtils.isInEventLoop()) {
            AsyncUtils.waitQuietly(future);
        }
        return future;
    }

    public void ensureInvocationNotTimeout() throws InvocationException {
        EventManager.post((Object)new InvocationTimeoutCheckEvent(this));
    }
}

