/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.auth.SignRequest;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtil.class);
    private static final List<AuthHeaderProvider> authHeaderProviders = SPIServiceUtils.getSortedService(AuthHeaderProvider.class);

    public static SignRequest createSignRequest(String method, String endpoint, Map<String, String> headers, InputStream content) {
        String parameters;
        SignRequest signReq = new SignRequest();
        try {
            signReq.setEndpoint(new URI(endpoint));
        }
        catch (URISyntaxException e) {
            LOGGER.warn("set uri failed, uri is {}, message: {}", (Object)endpoint, (Object)e.getMessage());
        }
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        if (endpoint.contains("?") && !StringUtils.isEmpty((String)(parameters = endpoint.substring(endpoint.indexOf("?") + 1)))) {
            String[] parameterArray;
            for (String p : parameterArray = parameters.split("&")) {
                String key = p.split("=")[0];
                String value = p.split("=")[1];
                if (!queryParams.containsKey(key)) {
                    queryParams.put(key, new String[]{value});
                    continue;
                }
                ArrayList<Object> vals = new ArrayList<Object>(Arrays.asList((Object[])queryParams.get(key)));
                vals.add(value);
                queryParams.put(key, vals.toArray(new String[vals.size()]));
            }
        }
        signReq.setQueryParams(queryParams);
        signReq.setHeaders(headers);
        signReq.setHttpMethod(method);
        signReq.setContent(content);
        return signReq;
    }

    public static List<AuthHeaderProvider> getAuthHeaderProviders() {
        return authHeaderProviders;
    }
}

