/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.arguments.producer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.bean.Setter;
import org.apache.servicecomb.swagger.invocation.SwaggerInvocation;
import org.apache.servicecomb.swagger.invocation.arguments.producer.ProducerArgumentMapper;

public class ProducerBeanParamMapper
extends ProducerArgumentMapper {
    protected String invocationArgumentName;
    private final Class<?> producerParamType;
    private final List<FieldMeta> fields = new ArrayList<FieldMeta>();

    public ProducerBeanParamMapper(String invocationArgumentName, Class<?> producerParamType) {
        this.invocationArgumentName = invocationArgumentName;
        this.producerParamType = producerParamType;
    }

    public void addField(String swaggerParameterName, Setter<Object, Object> setter) {
        this.fields.add(new FieldMeta(swaggerParameterName, setter));
    }

    @Override
    public void swaggerArgumentToInvocationArguments(SwaggerInvocation invocation, Map<String, Object> swaggerArguments, Map<String, Object> invocationArguments) {
        try {
            Object paramInstance = this.producerParamType.newInstance();
            invocationArguments.put(this.invocationArgumentName, paramInstance);
            for (FieldMeta fieldMeta : this.fields) {
                Object value = swaggerArguments.get(fieldMeta.swaggerParameterName);
                if (value == null) continue;
                fieldMeta.setter.set(paramInstance, value);
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("failed to map bean param.", e);
        }
    }

    private static class FieldMeta {
        String swaggerParameterName;
        Setter<Object, Object> setter;

        public FieldMeta(String swaggerParameterName, Setter<Object, Object> setter) {
            this.swaggerParameterName = swaggerParameterName;
            this.setter = setter;
        }
    }
}

