/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.foundation.common.RegisterManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public final class ProduceProcessorManager
extends RegisterManager<String, Map<String, ProduceProcessor>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProduceProcessorManager.class);
    private static final List<ProduceProcessor> produceProcessor = SPIServiceUtils.getSortedService(ProduceProcessor.class);
    private static final String NAME = "produce processor mgr";
    public static final String DEFAULT_TYPE = "application/json";
    public static final String DEFAULT_SERIAL_CLASS = "servicecomb_default_class";
    public static final ProduceProcessorManager INSTANCE = new ProduceProcessorManager();
    private final Map<String, ProduceProcessor> nonSerialViewMap = new HashMap<String, ProduceProcessor>();
    private final Map<String, ProduceProcessor> jsonProcessorMap;
    private final Map<String, ProduceProcessor> plainProcessorMap;
    private final Map<String, ProduceProcessor> defaultProcessorMap;

    private ProduceProcessorManager() {
        super(NAME);
        produceProcessor.forEach(processor -> {
            this.nonSerialViewMap.put(processor.getName(), (ProduceProcessor)processor);
            Map prodProcessorMap = this.getObjMap().computeIfAbsent(processor.getName(), key -> new HashMap());
            prodProcessorMap.putIfAbsent(processor.getSerializationView(), processor);
        });
        this.jsonProcessorMap = (Map)this.ensureFindValue(DEFAULT_TYPE);
        this.plainProcessorMap = (Map)this.ensureFindValue("text/plain");
        this.defaultProcessorMap = this.jsonProcessorMap;
    }

    private static ProduceProcessor cloneNewProduceProcessor(Class<?> serialViewClass, Map<String, ProduceProcessor> produceViewMap) {
        try {
            ProduceProcessor newInstance = (ProduceProcessor)produceViewMap.get(DEFAULT_SERIAL_CLASS).getClass().newInstance();
            newInstance.setSerializationView(serialViewClass);
            return newInstance;
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to create produceProcessor with {}", (Object)serialViewClass.getName(), (Object)e);
            return produceViewMap.get(DEFAULT_SERIAL_CLASS);
        }
    }

    public Map<String, ProduceProcessor> getOrCreateAcceptMap(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.nonSerialViewMap;
        }
        HashMap<String, ProduceProcessor> result = new HashMap<String, ProduceProcessor>();
        this.getObjMap().forEach((acceptKey, viewMap) -> {
            ProduceProcessor produceProcessor = viewMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, viewMap));
            result.put((String)acceptKey, produceProcessor);
        });
        return result;
    }

    public ProduceProcessor findProcessor(String acceptType, Class<?> serialViewClass) {
        Map viewMap = (Map)this.findValue(acceptType);
        if (CollectionUtils.isEmpty((Map)viewMap)) {
            return null;
        }
        if (serialViewClass == null) {
            return (ProduceProcessor)viewMap.get(DEFAULT_SERIAL_CLASS);
        }
        return viewMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, viewMap));
    }

    public ProduceProcessor findJsonProcessorByViewClass(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.jsonProcessorMap.get(DEFAULT_SERIAL_CLASS);
        }
        return this.jsonProcessorMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, this.jsonProcessorMap));
    }

    public ProduceProcessor findDefaultProcessorByViewClass(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.defaultProcessorMap.get(DEFAULT_SERIAL_CLASS);
        }
        return this.defaultProcessorMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, this.defaultProcessorMap));
    }

    public ProduceProcessor findPlainProcessorByViewClass(Class<?> serialViewClass) {
        if (serialViewClass == null) {
            return this.plainProcessorMap.get(DEFAULT_SERIAL_CLASS);
        }
        return this.plainProcessorMap.computeIfAbsent(serialViewClass.getName(), viewKey -> ProduceProcessorManager.cloneNewProduceProcessor(serialViewClass, this.plainProcessorMap));
    }

    public ProduceProcessor findDefaultJsonProcessor() {
        return this.jsonProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }

    public ProduceProcessor findDefaultProcessor() {
        return this.defaultProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }

    public ProduceProcessor findDefaultPlainProcessor() {
        return this.plainProcessorMap.get(DEFAULT_SERIAL_CLASS);
    }
}

