/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.stream;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.servicecomb.foundation.common.io.AsyncCloseable;

public class OutputStreamToWriteStream
implements WriteStream<Buffer>,
AsyncCloseable<Void> {
    private static final int DEFAULT_MAX_BUFFERS = 4;
    private static final int SMALLEST_MAX_BUFFERS = 2;
    private final OutputStream outputStream;
    private final Context context;
    private final boolean autoCloseOutputStream;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> drainHandler;
    private Runnable closedDeferred;
    private boolean closed;
    private final Queue<Buffer> buffers = new ConcurrentLinkedQueue<Buffer>();
    private int currentBufferCount;
    private int maxBuffers = 4;
    private int drainMark = this.maxBuffers / 2;

    public OutputStreamToWriteStream(Context context, OutputStream outputStream, boolean autoCloseOutputStream) {
        this.context = context;
        this.outputStream = outputStream;
        this.autoCloseOutputStream = autoCloseOutputStream;
    }

    public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)t);
        }
    }

    public synchronized Future<Void> write(Buffer data) {
        Promise result = Promise.promise();
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)ar -> {
            if (ar.failed()) {
                this.handleException(ar.cause());
            }
            result.complete();
        }));
        return result.future();
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        ++this.currentBufferCount;
        this.buffers.add(data);
        this.context.executeBlocking(this::writeInWorker, true, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInWorker(Promise<Void> future) {
        while (true) {
            Buffer buffer;
            if ((buffer = this.buffers.poll()) == null) {
                future.complete();
                return;
            }
            try {
                this.outputStream.write(buffer.getBytes());
                OutputStreamToWriteStream outputStreamToWriteStream = this;
                synchronized (outputStreamToWriteStream) {
                    --this.currentBufferCount;
                    Runnable action = this.currentBufferCount == 0 && this.closedDeferred != null ? this.closedDeferred : this::checkDrained;
                    action.run();
                }
            }
            catch (IOException e) {
                --this.currentBufferCount;
                future.fail((Throwable)e);
                return;
            }
        }
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.close();
    }

    public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
        this.maxBuffers = maxSize < 2 ? 2 : maxSize;
        this.drainMark = this.maxBuffers / 2;
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return this.currentBufferCount >= this.maxBuffers;
    }

    public synchronized WriteStream<Buffer> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    private synchronized void checkDrained() {
        if (this.drainHandler != null && this.currentBufferCount <= this.drainMark) {
            Handler<Void> handler = this.drainHandler;
            this.drainHandler = null;
            handler.handle(null);
        }
    }

    public CompletableFuture<Void> close() {
        return this.closeInternal();
    }

    private void check() {
        this.checkClosed();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException(this.getClass().getName() + " is closed");
        }
    }

    private synchronized CompletableFuture<Void> closeInternal() {
        this.check();
        this.closed = true;
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.currentBufferCount == 0) {
            this.doClose(future);
        } else {
            this.closedDeferred = () -> this.doClose(future);
        }
        return future;
    }

    private void doClose(CompletableFuture<Void> future) {
        if (this.autoCloseOutputStream) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                future.completeExceptionally(new IllegalStateException("failed to close outputStream.", e));
                return;
            }
        }
        future.complete(null);
    }
}

