/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import com.netflix.hystrix.HystrixObservable;
import org.apache.servicecomb.bizkeeper.BizkeeperHandler;
import org.apache.servicecomb.bizkeeper.Configuration;
import org.apache.servicecomb.bizkeeper.FallbackPolicyManager;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.Response;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subjects.ReplaySubject;

public class BizkeeperHandlerDelegate {
    private final BizkeeperHandler handler;

    public BizkeeperHandlerDelegate(BizkeeperHandler handler) {
        this.handler = handler;
    }

    protected HystrixObservable<Response> createBizkeeperCommand(Invocation invocation) {
        if (Configuration.INSTANCE.isFallbackForce(this.handler.groupname, invocation.getMicroserviceName(), invocation.getOperationMeta().getMicroserviceQualifiedName())) {
            return this.forceFallbackCommand(invocation);
        }
        return this.handler.createBizkeeperCommand(invocation);
    }

    protected HystrixObservable<Response> forceFallbackCommand(final Invocation invocation) {
        return new HystrixObservable<Response>(){

            public Observable<Response> observe() {
                ReplaySubject subject = ReplaySubject.create();
                Subscription sourceSubscription = this.toObservable().subscribe((Observer)subject);
                return subject.doOnUnsubscribe(() -> ((Subscription)sourceSubscription).unsubscribe());
            }

            public Observable<Response> toObservable() {
                return Observable.create(f -> {
                    try {
                        f.onNext((Object)FallbackPolicyManager.getFallbackResponse(((BizkeeperHandlerDelegate)BizkeeperHandlerDelegate.this).handler.groupname, null, invocation));
                    }
                    catch (Exception e) {
                        f.onError((Throwable)e);
                    }
                });
            }
        };
    }
}

