/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.http;

import com.fasterxml.jackson.databind.JavaType;
import com.netflix.config.DynamicPropertyFactory;
import java.util.Collection;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.HttpStatus;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientFilter
implements HttpClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpClientFilter.class);
    private static final boolean enabled = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.http.filter.client.default.enabled", true).get();

    public int getOrder() {
        return 10000;
    }

    public boolean enabled() {
        return enabled;
    }

    public void beforeSendRequest(Invocation invocation, HttpServletRequestEx requestEx) {
    }

    protected ProduceProcessor findProduceProcessor(RestOperationMeta restOperation, HttpServletResponseEx responseEx) {
        String contentType = responseEx.getHeader("Content-Type");
        if (contentType == null) {
            return null;
        }
        String contentTypeForFind = contentType;
        int idx = contentType.indexOf(59);
        if (idx != -1) {
            contentTypeForFind = contentType.substring(0, idx);
        }
        return restOperation.findProduceProcessor(contentTypeForFind);
    }

    protected Response extractResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        Object result = invocation.getHandlerContext().get("servicecomb-readStreamPart");
        if (result != null) {
            return Response.create((Response.StatusType)responseEx.getStatusType(), result);
        }
        OperationMeta operationMeta = invocation.getOperationMeta();
        JavaType responseType = invocation.findResponseType(responseEx.getStatus());
        RestOperationMeta swaggerRestOperation = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        ProduceProcessor produceProcessor = this.findProduceProcessor(swaggerRestOperation, responseEx);
        if (produceProcessor == null) {
            String msg = String.format("method %s, path %s, statusCode %d, reasonPhrase %s, response content-type %s is not supported", swaggerRestOperation.getHttpMethod(), swaggerRestOperation.getAbsolutePath(), responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase(), responseEx.getHeader("Content-Type"));
            LOGGER.warn(msg);
            produceProcessor = ProduceProcessorManager.INSTANCE.findDefaultProcessor();
        }
        try {
            result = produceProcessor.decodeResponse(responseEx.getBodyBuffer(), responseType);
            Response response = Response.create((Response.StatusType)responseEx.getStatusType(), result);
            if (response.isFailed()) {
                LOGGER.warn("invoke operation [{}] failed, status={}, msg={}", new Object[]{invocation.getMicroserviceQualifiedName(), responseEx.getStatusType().getStatusCode(), result == null ? "" : result.toString()});
            }
            return response;
        }
        catch (Exception e) {
            LOGGER.error("failed to decode response body, exception is [{}]", (Object)e.getMessage());
            String msg = String.format("method %s, path %s, statusCode %d, reasonPhrase %s, response content-type %s is not supported", swaggerRestOperation.getHttpMethod(), swaggerRestOperation.getAbsolutePath(), responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase(), responseEx.getHeader("Content-Type"));
            if (HttpStatus.isSuccess((int)responseEx.getStatus())) {
                return Response.createConsumerFail((Throwable)new InvocationException(400, responseEx.getStatusType().getReasonPhrase(), (Object)new CommonExceptionData(msg), (Throwable)e));
            }
            return Response.createConsumerFail((Throwable)new InvocationException(responseEx.getStatus(), responseEx.getStatusType().getReasonPhrase(), (Object)new CommonExceptionData(msg), (Throwable)e));
        }
    }

    public Response afterReceiveResponse(Invocation invocation, HttpServletResponseEx responseEx) {
        Response response = this.extractResponse(invocation, responseEx);
        for (String headerName : responseEx.getHeaderNames()) {
            if (headerName.equals(":status")) continue;
            Collection headerValues = responseEx.getHeaders(headerName);
            for (String headerValue : headerValues) {
                response.addHeader(headerName, headerValue);
            }
        }
        return response;
    }
}

